package com.xdja.base.util.page;

/**
 * @ProjectName：ucm
 * @ClassName：SQLUtil
 * @Description：实现分页的工具类
 * @author: mayanpei
 * @date: 2014-5-21 上午8:52:40
 * 
 */
public class SQLUtil {

	/**
	 * 本工具类内部使用的变量
	 */
	private String sql; // 查询sql
	private int pageNo; // 当前页数
	private int pageSize; // 一页显示的记录数

	/**
	 * 
	 * @Description：构造方法
	 * @param sql
	 *            SQL语句
	 */
	public SQLUtil(String sql) {
		this.sql = sql;
	}

	/**
	 * @Description：SQL分页构造方法
	 * @param sql
	 *            SQL语句
	 * @param pageNo
	 *            当前页
	 * @param pageSize
	 *            一页显示条数
	 */
	public SQLUtil(String sql, int pageNo, int pageSize) {
		this.sql = sql;
		this.pageNo = pageNo;
		this.pageSize = pageSize;
	}

	/**
	 * @Description：获取查询SQL语句查询出来的记录数量的语句
	 * @author: mayanpei
	 * @date: 2014-9-3 上午11:00:17
	 * @return
	 */
	public String getCountSQL() {
		StringBuilder sb = new StringBuilder("SELECT COUNT(0) FROM (");
		sb.append(this.sql);
		sb.append(")tmp");
		return sb.toString();
	}

	/**
	 * @Description：获取查询SQL语句分页所需的SQL语句
	 * @author: mayanpei
	 * @date: 2014-9-3 上午11:00:06
	 * @return
	 */
	public String getPageSql() {
		StringBuilder sqlBuilder = new StringBuilder();
		sqlBuilder.append(this.sql).append(" LIMIT ").append(pageSize).append(" OFFSET ").append(getEnd());
		return sqlBuilder.toString();
	}

	/**
	 * @Description： 根据要查询的起始页和每页要显示的数量计算每页的结束号
	 * @author: mayanpei
	 * @date: 2014-9-3 上午11:01:16
	 * @return
	 */
	public int getEnd() {
		return (this.pageNo - 1) * this.pageSize;
	}

	public String getSql() {
		return sql;
	}

	public void setSql(String sql) {
		this.sql = sql;
	}

	public int getPageNo() {
		return pageNo;
	}

	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
}
