package com.xdja.update;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * <b>Description: 检测升级任务</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/10/17 11:41.
 */
public class CheckTask extends AsyncTask<String, Integer, CheckResult> {

    /**
     * The constant TAG.
     */
    public static final String TAG = CheckTask.class.getSimpleName();

    /**
     * The constant DOC_HEADER.
     */
    public static final String DOC_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    @SuppressLint("StaticFieldLeak")
    @NonNull
    private final Context cxt;

    @NonNull
    private CheckCallback checkCallback;

    private CheckProtocol checkProtocol;

    /**
     * Instantiates a new Check task.
     *
     * @param context  the context
     * @param callback the callback
     */
    public CheckTask(@NonNull Context context, @NonNull CheckCallback callback) {
        this.cxt = context.getApplicationContext();
        this.checkCallback = callback;
    }

    /**
     * Instantiates a new Check task.
     *
     * @param context  the context
     * @param protocol the protocol
     * @param callback the callback
     */
    public CheckTask(
            @NonNull Context context,
            @NonNull CheckProtocol protocol, @NonNull CheckCallback callback) {
        this(context, callback);
        this.checkProtocol = checkProtocol;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.checkCallback.onChecking();
    }

    @Override
    protected void onPostExecute(CheckResult result) {
        super.onPostExecute(result);
        if (result != null) {
            this.checkCallback.onCheckResult(result);
        } else {
            this.checkCallback.onCheckResult(buildErrorCheckResult("发生未知错误"));
        }
    }

    @SuppressWarnings("ConstantConditions")
    @Override
    protected CheckResult doInBackground(String... params) {

        CheckProtocol protocol = null;
        //调用方未传入检测升级相关信息，程序自己进行构建
        if (this.checkProtocol == null) {
            try {
                //构建检测升级协议对象（从ClientVersion.xml中读取）
                protocol = buildCheckProtocol(params[0]);
            } catch (IOException | XmlPullParserException e) {
                return buildErrorCheckResult("解析升级配置出错，错误信息 ： " + e.getMessage());
            }
        } else {
            //使用调用方传入的检测升级相关信息
            protocol = this.checkProtocol;
        }

        if (protocol != null) {
            //从读取到的信息中获取Ip地址和端口号，构建baseUrl
            UpdateManager.getInstance().setBaseUrl("http://"
                    + protocol.getServerIp()
                    + ":"
                    + protocol.getServerPort()
                    + "/Update/update");
            String result = null;
            try {
                String protocolStr = protocol.toString();
                Log.d(TAG, "检测升级请求参数 : \r\n" + protocolStr);
                //检测升级
                result = checkUpdate(UpdateManager.getInstance().getBaseUrl(), protocolStr);
                Log.d(TAG, "升级请求结果为 ： " + result);
            } catch (Exception e) {
                return buildErrorCheckResult("请求升级失败 ： " + e.getMessage());
            }

            if (!TextUtils.isEmpty(result)) {

                //解析升级检测结果
                int firstIndex = result.indexOf(DOC_HEADER);
                int lastIndex = result.lastIndexOf(DOC_HEADER);
                String updateResult;
                String updateContent = null;
                if (firstIndex == lastIndex) {
                    updateResult = result;
                } else {
                    updateResult = result.substring(firstIndex, lastIndex);
                    updateContent = result.substring(lastIndex);
                }
                Log.d(TAG, "updateResult : " + updateResult + "\r\nupdateContent : " + updateContent);

                try {
                    if (!TextUtils.isEmpty(updateResult)) {
                        XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
                        XmlPullParser parser = parserFactory.newPullParser();
                        parser.setInput(new StringReader(updateResult));
                        CheckResult checkResult = resolveUpdateResult(parser);

                        if (!TextUtils.isEmpty(updateContent) && checkResult != null) {
                            XmlPullParser pullParser = parserFactory.newPullParser();
                            pullParser.setInput(new StringReader(updateContent));
                            checkResult.setUpdates(resolveUpdateContent(pullParser));
                        }
                        return checkResult;
                    }
                    return buildErrorCheckResult("升级服务器响应数据有误");
                } catch (XmlPullParserException | IOException e) {
                    return buildErrorCheckResult("解析升级数据失败 : " + e.getMessage());
                }
            }
            return buildErrorCheckResult("升级服务器响应数据为空");
        }
        return buildErrorCheckResult("请求参数有误");
    }

    @SuppressWarnings("ConstantConditions")
    private CheckProtocol buildCheckProtocol(String updateConfig) throws IOException, XmlPullParserException {
        CheckProtocol protocol = null;
        List<CheckProtocol.Ver> vers = null;
        CheckProtocol.Ver ver = null;
        InputStream open = this.cxt.getAssets().open(updateConfig);
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput(open, "UTF-8");
        int eventType = parser.getEventType();
        while (eventType != XmlPullParser.END_DOCUMENT) {
            switch (eventType) {
                case XmlPullParser.START_DOCUMENT:
                    break;
                case XmlPullParser.START_TAG:
                    String name = parser.getName();
                    if (name.equals("Root")) {
                        protocol = new CheckProtocol();
                    } else if (name.equals("ServerIP")) {
                        protocol.setServerIp(parser.nextText());
                    } else if (name.equals("ServerPort")) {
                        protocol.setServerPort(parser.nextText());
                    } else if (name.equals("Factory")) {
                        protocol.setFactory(parser.nextText());
                    } else if (name.equals("OS")) {
                        protocol.setOs(parser.nextText());
                    } else if (name.equals("Mod")) {
                        protocol.setMod(parser.nextText());
                    } else if (name.equals("Soft")) {
                        protocol.setSoft(parser.nextText());
                    } else if (name.equals("UserName")) {
                        protocol.setUserName(parser.nextText());
                    } else if (name.equals("Ver")) {
                        if (vers == null) {
                            vers = new ArrayList<>();
                        }
                        ver = new CheckProtocol.Ver();
                    } else if (name.equals("Version")) {
                        if (ver != null) {
                            ver.setVerName(parser.nextText());
                        }
                    } else if (name.equals("Date")) {
                        if (ver != null) {
                            ver.setDate(parser.nextText());
                        }
                    } else if (name.equals("VerType")) {
                        if (ver != null) {
                            ver.setVerType(parser.nextText());
                        }
                    }
                    break;
                case XmlPullParser.END_TAG:
                    String endName = parser.getName();
                    if (endName.equals("Ver")) {
                        if (vers != null) {
                            vers.add(ver);
                        }
                    } else if (endName.equals("Root")) {
                        if (protocol != null) {
                            protocol.setVers(vers);
                        }
                    }
                    break;
                default:
                    break;
            }
            eventType = parser.next();
        }
        return protocol;
    }

    private CheckResult resolveUpdateResult(XmlPullParser parser)
            throws XmlPullParserException, IOException {
        CheckResult checkResult = null;
        int eventType = parser.getEventType();
        while (eventType != XmlPullParser.END_DOCUMENT) {
            switch (eventType) {
                case XmlPullParser.START_DOCUMENT:
                    checkResult = new CheckResult();
                    break;
                case XmlPullParser.START_TAG:
                    String name = parser.getName();
                    if (name.equals("Req")) {
                        if (checkResult != null) {
                            checkResult.setReq(parser.nextText());
                        }
                    } else if (name.equals("Result")) {
                        if (checkResult != null) {
                            checkResult.setResult(parser.nextText());
                        }
                    } else if (name.equals("ModPower")) {
                        if (checkResult != null) {
                            checkResult.setModPower(parser.nextText());
                        }
                    } else if (name.equals("Msg")) {
                        if (checkResult != null) {
                            checkResult.setMsg(parser.nextText());
                        }
                    }
                    break;
                default:
                    break;
            }
            eventType = parser.next();
        }
        return checkResult;
    }

    private List<CheckResult.Update> resolveUpdateContent(XmlPullParser pullParser)
            throws XmlPullParserException, IOException {
        List<CheckResult.Update> updates = null;
        CheckResult.Update update = null;
        List<CheckResult.Update.File> files = null;
        CheckResult.Update.File file = null;
        int event = pullParser.getEventType();
        while (event != XmlPullParser.END_DOCUMENT) {
            switch (event) {
                case XmlPullParser.START_DOCUMENT:
                    updates = new ArrayList<>();
                    break;
                case XmlPullParser.START_TAG:
                    String name = pullParser.getName();
                    if (name.equals("Update")) {
                        update = new CheckResult.Update();
                    } else if (name.equals("VerType")) {
                        if (update != null) {
                            update.setVerType(pullParser.nextText());
                        }
                    } else if (name.equals("Version")) {
                        if (update != null) {
                            update.setVersion(pullParser.nextText());
                        }
                    } else if (name.equals("Date")) {
                        if (update != null) {
                            update.setDate(pullParser.nextText());
                        }
                    } else if (name.equals("Comment")) {
                        if (update != null) {
                            update.setComment(pullParser.nextText());
                        }
                    } else if (name.equals("UpdateTag")) {
                        if (update != null) {
                            update.setUpdateTag(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (name.equals("Files")) {
                        files = new ArrayList<>();
                    } else if (name.equals("File")) {
                        file = new CheckResult.Update.File();
                    } else if (name.equals("RPath")) {
                        if (file != null) {
                            file.setrPath(pullParser.nextText());
                        }
                    } else if (name.equals("LPath")) {
                        if (file != null) {
                            file.setlPath(pullParser.nextText());
                        }
                    } else if (name.equals("FName")) {
                        if (file != null) {
                            file.setfName(pullParser.nextText());
                        }
                    } else if (name.equals("FSize")) {
                        if (file != null) {
                            file.setfSize(Long.parseLong(pullParser.nextText()));
                        }
                    } else if (name.equals("Action")) {
                        if (file != null) {
                            file.setAction(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (name.equals("State")) {
                        if (file != null) {
                            file.setState(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (name.equals("CSize")) {
                        if (file != null) {
                            file.setcSize(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (name.equals("CheckCode")) {
                        if (file != null) {
                            file.setCheckCode(pullParser.nextText());
                        }
                    } else if (name.equals("DeleteDb")) {
                        if (file != null) {
                            file.setDeleteDb(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (name.equals("FileId")) {
                        if (file != null) {
                            file.setFileId(pullParser.nextText());
                        }
                    }
                    break;
                case XmlPullParser.END_TAG:
                    String endName = pullParser.getName();
                    if (endName.equals("File")) {
                        if (files != null) {
                            files.add(file);
                        }
                    } else if (endName.equals("Files")) {
                        if (update != null) {
                            update.setFiles(files);
                        }
                    } else if (endName.equals("Update")) {
                        if (updates != null) {
                            updates.add(update);
                        }
                    } else if (endName.equals("Updates")) {
                        /*if (checkResult != null) {
                            checkResult.setUpdates(updates);
                        }*/
                    }
                    break;
                default:
                    break;
            }
            event = pullParser.next();
        }
        return updates;
    }

    @NonNull
    private CheckResult buildErrorCheckResult(String msg) {
        CheckResult checkResult = new CheckResult();
        checkResult.setResult(CheckResult.RESULT_UPDATE_ERROR);
        checkResult.setMsg(msg);
        return checkResult;
    }

    private String checkUpdate(String baseUrl, String checkProtocl) throws Exception {
        URL url = new URL(baseUrl + "/httpupdate.do");
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(15 * 1000);
        connection.setReadTimeout(15 * 1000);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("content-type", "text/html");

        BufferedWriter bufferedWriter = new BufferedWriter(
                new OutputStreamWriter(connection.getOutputStream(), "utf-8")
        );
        bufferedWriter.write(checkProtocl);
        bufferedWriter.flush();
        bufferedWriter.close();


        int responseCode = connection.getResponseCode();
        if (responseCode == HttpURLConnection.HTTP_OK) {
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            StringWriter stringWriter = new StringWriter();
            char[] cbuffer = new char[100];
            int readCount = 0;
            while ((readCount = reader.read(cbuffer)) != -1) {
                stringWriter.write(cbuffer, 0, readCount);
            }
            stringWriter.flush();
            stringWriter.close();
            reader.close();
            return stringWriter.toString();
        }
        throw new Exception("http请求发生错误，错误码：" + responseCode);
    }
}
