package com.xdja.update;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

/**
 * <b>Description: 文件下载回调接口定义</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/11/1 16:41.
 */
public interface DownloadCallback {

    /**
     * 下载开始
     *
     * @param fileId 文件ID
     */
    void onStart(@NonNull String fileId);

    /**
     * 下载进度更新回调接口
     *
     * @param fileId    文件ID
     * @param totalSize 文件总大小
     * @param cSize     已下载大小
     */
    void onProgress(@NonNull String fileId, long totalSize, long cSize);

    /**
     * 下载已经停止
     *
     * @param fileId 文件ID
     */
    void onStop(@NonNull String fileId);

    /**
     * 下载发生错误
     *
     * @param fileId   文件ID
     * @param errorMsg 错误信息
     * @param ex       异常对象
     */
    void onError(@NonNull String fileId, @Nullable String errorMsg, @Nullable Exception ex);

    /**
     * 下载完成
     *
     * @param fileId 文件ID
     */
    void onComplete(@NonNull String fileId);

    /**
     * 更新文件下载单元(单位：byte)
     *
     * @return 下载单元大小 int
     */
    int unit();
}
