package com.xdja.update.bean;

import android.support.annotation.StringDef;

import java.util.List;

/**
 * <b>Description: 检测升级协议类定义</b>
 * Created by <a href="mailto:fjd@xdja.com">fanjiandong</a> on 2017/10/17 15:49.
 */
public class CheckProtocol {

    /**
     * 老版本协议
     */
    public static final String PACT_VERSION_TRADITIONAL = "PACT_VERSION_TRADITIONAL";
    /**
     * 4.0版本协议
     */
    //public static final String PACT_VERSION_4_0 = "4.0";
    /**
     * 4.1版本协议
     */
    public static final String PACT_VERSION_4_1 = "4.1";
    /**
     * 4.2版本协议
     */
    public static final String PACT_VERSION_4_2 = "4.2";

    /**
     * The constant DOCUMENT_PREFIX.
     */
    public static final String DOCUMENT_PREFIX = "  ";
    /**
     * The constant REQ_DEFAULT.
     */
    public static final String REQ_DEFAULT = "checkver";

    /**
     * 版本协议定义
     */
//@StringDef({PACT_VERSION_TRADITIONAL, PACT_VERSION_4_0, PACT_VERSION_4_1, PACT_VERSION_4_2})
    @StringDef({PACT_VERSION_TRADITIONAL, PACT_VERSION_4_1, PACT_VERSION_4_2})
    public @interface PactVersion {}

    /**
     * 使用的版本协议，默认为{@link #PACT_VERSION_4_1}，注：老协议{@link #PACT_VERSION_TRADITIONAL}不发送该节点
     */
    @PactVersion
    private String pactVersion = PACT_VERSION_4_1;
    /**
     * 请求类别，默认为{@link #REQ_DEFAULT}
     */
    private String req = REQ_DEFAULT;
    /**
     * 升级服务器Ip地址。注：该节点为发送检测请求地址，不作为检测协议的内容
     */
    private String serverIp;
    /**
     * 升级服务端口号。注：该节点为发送检测请求端口，不作为检测协议的内容
     */
    private String serverPort;
    /**
     * 手机厂商
     */
    private String factory;
    /**
     * 手机型号
     */
    private String mod;
    /**
     * 系统平台
     */
    private String os;
    /**
     * 升级软件名称
     */
    private String soft;
    /**
     * 当前用户
     */
    private String userName;
    /**
     * 用户权限。注:4.2版本{@link #PACT_VERSION_4_2}需要填充该节点，其他版本无需填充。
     */
    private String power;
    /**
     * 版本号。注：该节点只有老协议{@link #PACT_VERSION_TRADITIONAL}需要发送，其他版本协议无需填充该节点
     */
    private String version;
    /**
     * 客户端版本信息队列（可能包含主框架和插件等多个组件的版本信息）
     */
    private List<Ver> vers;

    /**
     * Gets pact version.
     *
     * @return {@link #pactVersion}
     */
    @PactVersion
    public String getPactVersion() {
        return pactVersion;
    }

    /**
     * Sets pact version.
     *
     * @param pactVersion {@link #pactVersion}
     */
    public void setPactVersion(@PactVersion String pactVersion) {
        this.pactVersion = pactVersion;
    }

    /**
     * Gets server ip.
     *
     * @return {@link #serverIp}
     */
    public String getServerIp() {
        return serverIp;
    }

    /**
     * Sets server ip.
     *
     * @param serverIp {@link #serverIp}
     */
    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    /**
     * Gets server port.
     *
     * @return {@link #serverPort}
     */
    public String getServerPort() {
        return serverPort;
    }

    /**
     * Sets server port.
     *
     * @param serverPort {@link #serverPort}
     */
    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    /**
     * Gets req.
     *
     * @return {@link #req}
     */
    public String getReq() {
        return req;
    }

    /**
     * Sets req.
     *
     * @param req {@link #req}
     */
    public void setReq(String req) {
        this.req = req;
    }

    /**
     * Gets factory.
     *
     * @return {@link #factory}
     */
    public String getFactory() {
        return factory;
    }

    /**
     * Sets factory.
     *
     * @param factory {@link #factory}
     */
    public void setFactory(String factory) {
        this.factory = factory;
    }

    /**
     * Gets mod.
     *
     * @return {@link #mod}
     */
    public String getMod() {
        return mod;
    }

    /**
     * Sets mod.
     *
     * @param mod {@link #mod}
     */
    public void setMod(String mod) {
        this.mod = mod;
    }

    /**
     * Gets os.
     *
     * @return {@link #os}
     */
    public String getOs() {
        return os;
    }

    /**
     * Sets os.
     *
     * @param os {@link #os}
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * Gets soft.
     *
     * @return {@link #soft}
     */
    public String getSoft() {
        return soft;
    }

    /**
     * Sets soft.
     *
     * @param soft {@link #soft}
     */
    public void setSoft(String soft) {
        this.soft = soft;
    }

    /**
     * Gets user name.
     *
     * @return {@link #userName}
     */
    public String getUserName() {
        return userName;
    }

    /**
     * Sets user name.
     *
     * @param userName {@link #userName}
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * Gets power.
     *
     * @return {@link #power}
     */
    public String getPower() {
        return power;
    }

    /**
     * Sets power.
     *
     * @param power {@link #power}
     */
    public void setPower(String power) {
        this.power = power;
    }

    /**
     * Gets version.
     *
     * @return {@link #version}
     */
    public String getVersion() {
        return version;
    }

    /**
     * Sets version.
     *
     * @param version {@link #version}
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * Gets vers.
     *
     * @return {@link #vers}
     */
    public List<Ver> getVers() {
        return vers;
    }

    /**
     * Sets vers.
     *
     * @param vers {@link #vers}
     */
    public void setVers(List<Ver> vers) {
        this.vers = vers;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DOCUMENT_PREFIX);
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("<Root>");
        if (!pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<PactVersion>").append(pactVersion).append("</PactVersion>");
        }
        builder.append("<Req>").append(req).append("</Req>")
                .append("<Factory>").append(factory).append("</Factory>")
                .append("<Mod>").append(mod).append("</Mod>")
                .append("<OS>").append(os).append("</OS>")
                .append("<Soft>").append(soft).append("</Soft>")
                .append("<UserName>").append(userName).append("</UserName>");
        if (pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<Version>").append(version).append("</Version>");
        }
        if (pactVersion.equals(PACT_VERSION_4_2)) {
            builder.append("<Power>").append(power).append("</Power>");
        }

        if (!pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<Vers>");
            if (vers != null && !vers.isEmpty()) {
                for (Ver ver : vers)
                    builder.append(ver.toString());
            }
            builder.append("</Vers>");
        }
        builder.append("</Root>");
        return builder.toString();
    }

    /**
     * 版本信息请求类
     */
    public static class Ver {
        /**
         * 版本类型（包名）
         */
        private String verType;
        /**
         * 版本名称
         */
        private String verName;
        /**
         * 发布日期
         */
        private String date;

        /**
         * Gets ver type.
         *
         * @return {@link #verType}
         */
        public String getVerType() {
            return verType;
        }

        /**
         * Sets ver type.
         *
         * @param verType {@link #verType}
         */
        public void setVerType(String verType) {
            this.verType = verType;
        }

        /**
         * Gets ver name.
         *
         * @return {@link #verName}
         */
        public String getVerName() {
            return verName;
        }

        /**
         * Sets ver name.
         *
         * @param verName {@link #verName}
         */
        public void setVerName(String verName) {
            this.verName = verName;
        }

        /**
         * Gets date.
         *
         * @return {@link #verName}
         */
        public String getDate() {
            return date;
        }

        /**
         * Sets date.
         *
         * @param date {@link #date}
         */
        public void setDate(String date) {
            this.date = date;
        }

        @Override
        public String toString() {
            //noinspection StringBufferReplaceableByString
            return new StringBuilder()
                    .append("<Ver>")
                    .append("<VerType>").append(verType).append("</VerType>")
                    .append("<Version>").append(verName).append("</Version>")
                    .append("<Date>").append(date).append("</Date>")
                    .append("</Ver>")
                    .toString();
        }
    }
}
