/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.update.CheckCallback;
import com.xdja.update.UpdateManager;
import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class CheckTask
extends AsyncTask<String, Integer, CheckResult> {
    public static final String TAG = CheckTask.class.getSimpleName();
    public static final String DOC_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    @SuppressLint(value={"StaticFieldLeak"})
    @NonNull
    private final Context cxt;
    @NonNull
    private CheckCallback checkCallback;
    private CheckProtocol checkProtocol;

    public CheckTask(@NonNull Context context, @NonNull CheckCallback callback) {
        this.cxt = context.getApplicationContext();
        this.checkCallback = callback;
    }

    public CheckTask(@NonNull Context context, @NonNull CheckProtocol protocol, @NonNull CheckCallback callback) {
        this(context, callback);
        this.checkProtocol = this.checkProtocol;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.checkCallback.onChecking();
    }

    protected void onPostExecute(CheckResult result) {
        super.onPostExecute((Object)result);
        if (result != null) {
            this.checkCallback.onCheckResult(result);
        } else {
            this.checkCallback.onCheckResult(this.buildErrorCheckResult("\u53d1\u751f\u672a\u77e5\u9519\u8bef"));
        }
    }

    protected CheckResult doInBackground(String ... params) {
        CheckProtocol protocol = null;
        if (this.checkProtocol == null) {
            try {
                protocol = this.buildCheckProtocol(params[0]);
            }
            catch (IOException | XmlPullParserException e) {
                return this.buildErrorCheckResult("\u89e3\u6790\u5347\u7ea7\u914d\u7f6e\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f \uff1a " + e.getMessage());
            }
        } else {
            protocol = this.checkProtocol;
        }
        if (protocol != null) {
            UpdateManager.getInstance().setBaseUrl("http://" + protocol.getServerIp() + ":" + protocol.getServerPort() + "/Update/update");
            String result = null;
            try {
                String protocolStr = protocol.toString();
                Log.d((String)TAG, (String)("\u68c0\u6d4b\u5347\u7ea7\u8bf7\u6c42\u53c2\u6570 : \r\n" + protocolStr));
                result = this.checkUpdate(UpdateManager.getInstance().getBaseUrl(), protocolStr);
                Log.d((String)TAG, (String)("\u5347\u7ea7\u8bf7\u6c42\u7ed3\u679c\u4e3a \uff1a " + result));
            }
            catch (Exception e) {
                return this.buildErrorCheckResult("\u8bf7\u6c42\u5347\u7ea7\u5931\u8d25 \uff1a " + e.getMessage());
            }
            if (!TextUtils.isEmpty((CharSequence)result)) {
                String updateResult;
                int firstIndex = result.indexOf(DOC_HEADER);
                int lastIndex = result.lastIndexOf(DOC_HEADER);
                String updateContent = null;
                if (firstIndex == lastIndex) {
                    updateResult = result;
                } else {
                    updateResult = result.substring(firstIndex, lastIndex);
                    updateContent = result.substring(lastIndex);
                }
                Log.d((String)TAG, (String)("updateResult : " + updateResult + "\r\nupdateContent : " + updateContent));
                try {
                    if (!TextUtils.isEmpty((CharSequence)updateResult)) {
                        XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
                        XmlPullParser parser = parserFactory.newPullParser();
                        parser.setInput((Reader)new StringReader(updateResult));
                        CheckResult checkResult = this.resolveUpdateResult(parser);
                        if (!TextUtils.isEmpty((CharSequence)updateContent) && checkResult != null) {
                            XmlPullParser pullParser = parserFactory.newPullParser();
                            pullParser.setInput((Reader)new StringReader(updateContent));
                            checkResult.setUpdates(this.resolveUpdateContent(pullParser));
                        }
                        return checkResult;
                    }
                    return this.buildErrorCheckResult("\u5347\u7ea7\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u6709\u8bef");
                }
                catch (IOException | XmlPullParserException e) {
                    return this.buildErrorCheckResult("\u89e3\u6790\u5347\u7ea7\u6570\u636e\u5931\u8d25 : " + e.getMessage());
                }
            }
            return this.buildErrorCheckResult("\u5347\u7ea7\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a");
        }
        return this.buildErrorCheckResult("\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
    }

    private CheckProtocol buildCheckProtocol(String updateConfig) throws IOException, XmlPullParserException {
        CheckProtocol protocol = null;
        ArrayList<CheckProtocol.Ver> vers = null;
        CheckProtocol.Ver ver = null;
        InputStream open = this.cxt.getAssets().open(updateConfig);
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput(open, "UTF-8");
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 0: {
                    break;
                }
                case 2: {
                    String name = parser.getName();
                    if (name.equals("Root")) {
                        protocol = new CheckProtocol();
                        break;
                    }
                    if (name.equals("ServerIP")) {
                        protocol.setServerIp(parser.nextText());
                        break;
                    }
                    if (name.equals("ServerPort")) {
                        protocol.setServerPort(parser.nextText());
                        break;
                    }
                    if (name.equals("Factory")) {
                        protocol.setFactory(parser.nextText());
                        break;
                    }
                    if (name.equals("OS")) {
                        protocol.setOs(parser.nextText());
                        break;
                    }
                    if (name.equals("Mod")) {
                        protocol.setMod(parser.nextText());
                        break;
                    }
                    if (name.equals("Soft")) {
                        protocol.setSoft(parser.nextText());
                        break;
                    }
                    if (name.equals("UserName")) {
                        protocol.setUserName(parser.nextText());
                        break;
                    }
                    if (name.equals("Ver")) {
                        if (vers == null) {
                            vers = new ArrayList<CheckProtocol.Ver>();
                        }
                        ver = new CheckProtocol.Ver();
                        break;
                    }
                    if (name.equals("Version")) {
                        if (ver == null) break;
                        ver.setVerName(parser.nextText());
                        break;
                    }
                    if (name.equals("Date")) {
                        if (ver == null) break;
                        ver.setDate(parser.nextText());
                        break;
                    }
                    if (!name.equals("VerType") || ver == null) break;
                    ver.setVerType(parser.nextText());
                    break;
                }
                case 3: {
                    String endName = parser.getName();
                    if (endName.equals("Ver")) {
                        if (vers == null) break;
                        vers.add(ver);
                        break;
                    }
                    if (!endName.equals("Root") || protocol == null) break;
                    protocol.setVers((List<CheckProtocol.Ver>)vers);
                    break;
                }
            }
            eventType = parser.next();
        }
        return protocol;
    }

    private CheckResult resolveUpdateResult(XmlPullParser parser) throws XmlPullParserException, IOException {
        CheckResult checkResult = null;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 0: {
                    checkResult = new CheckResult();
                    break;
                }
                case 2: {
                    String name = parser.getName();
                    if (name.equals("Req")) {
                        if (checkResult == null) break;
                        checkResult.setReq(parser.nextText());
                        break;
                    }
                    if (name.equals("Result")) {
                        if (checkResult == null) break;
                        checkResult.setResult(parser.nextText());
                        break;
                    }
                    if (name.equals("ModPower")) {
                        if (checkResult == null) break;
                        checkResult.setModPower(parser.nextText());
                        break;
                    }
                    if (!name.equals("Msg") || checkResult == null) break;
                    checkResult.setMsg(parser.nextText());
                    break;
                }
            }
            eventType = parser.next();
        }
        return checkResult;
    }

    private List<CheckResult.Update> resolveUpdateContent(XmlPullParser pullParser) throws XmlPullParserException, IOException {
        ArrayList<CheckResult.Update> updates = null;
        CheckResult.Update update = null;
        ArrayList<CheckResult.Update.File> files = null;
        CheckResult.Update.File file = null;
        int event = pullParser.getEventType();
        while (event != 1) {
            switch (event) {
                case 0: {
                    updates = new ArrayList<CheckResult.Update>();
                    break;
                }
                case 2: {
                    String name = pullParser.getName();
                    if (name.equals("Update")) {
                        update = new CheckResult.Update();
                        break;
                    }
                    if (name.equals("VerType")) {
                        if (update == null) break;
                        update.setVerType(pullParser.nextText());
                        break;
                    }
                    if (name.equals("Version")) {
                        if (update == null) break;
                        update.setVersion(pullParser.nextText());
                        break;
                    }
                    if (name.equals("Date")) {
                        if (update == null) break;
                        update.setDate(pullParser.nextText());
                        break;
                    }
                    if (name.equals("Comment")) {
                        if (update == null) break;
                        update.setComment(pullParser.nextText());
                        break;
                    }
                    if (name.equals("UpdateTag")) {
                        if (update == null) break;
                        update.setUpdateTag(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (name.equals("Files")) {
                        files = new ArrayList<CheckResult.Update.File>();
                        break;
                    }
                    if (name.equals("File")) {
                        file = new CheckResult.Update.File();
                        break;
                    }
                    if (name.equals("RPath")) {
                        if (file == null) break;
                        file.setrPath(pullParser.nextText());
                        break;
                    }
                    if (name.equals("LPath")) {
                        if (file == null) break;
                        file.setlPath(pullParser.nextText());
                        break;
                    }
                    if (name.equals("FName")) {
                        if (file == null) break;
                        file.setfName(pullParser.nextText());
                        break;
                    }
                    if (name.equals("FSize")) {
                        if (file == null) break;
                        file.setfSize(Long.parseLong(pullParser.nextText()));
                        break;
                    }
                    if (name.equals("Action")) {
                        if (file == null) break;
                        file.setAction(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (name.equals("State")) {
                        if (file == null) break;
                        file.setState(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (name.equals("CSize")) {
                        if (file == null) break;
                        file.setcSize(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (name.equals("CheckCode")) {
                        if (file == null) break;
                        file.setCheckCode(pullParser.nextText());
                        break;
                    }
                    if (name.equals("DeleteDb")) {
                        if (file == null) break;
                        file.setDeleteDb(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (!name.equals("FileId") || file == null) break;
                    file.setFileId(pullParser.nextText());
                    break;
                }
                case 3: {
                    String endName = pullParser.getName();
                    if (endName.equals("File")) {
                        if (files == null) break;
                        files.add(file);
                        break;
                    }
                    if (endName.equals("Files")) {
                        if (update == null) break;
                        update.setFiles((List<CheckResult.Update.File>)files);
                        break;
                    }
                    if (endName.equals("Update")) {
                        if (updates == null) break;
                        updates.add(update);
                        break;
                    }
                    if (!endName.equals("Updates")) break;
                    break;
                }
            }
            event = pullParser.next();
        }
        return updates;
    }

    @NonNull
    private CheckResult buildErrorCheckResult(String msg) {
        CheckResult checkResult = new CheckResult();
        checkResult.setResult("-1");
        checkResult.setMsg(msg);
        return checkResult;
    }

    private String checkUpdate(String baseUrl, String checkProtocl) throws Exception {
        URL url = new URL(baseUrl + "/httpupdate.do");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("content-type", "text/html");
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "utf-8"));
        bufferedWriter.write(checkProtocl);
        bufferedWriter.flush();
        bufferedWriter.close();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            StringWriter stringWriter = new StringWriter();
            char[] cbuffer = new char[100];
            int readCount = 0;
            while ((readCount = reader.read(cbuffer)) != -1) {
                stringWriter.write(cbuffer, 0, readCount);
            }
            stringWriter.flush();
            stringWriter.close();
            reader.close();
            return stringWriter.toString();
        }
        throw new Exception("http\u8bf7\u6c42\u53d1\u751f\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a" + responseCode);
    }
}

