/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.update.DownloadCallback;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.utils.EncryptUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownloadTask
extends AsyncTask<String, Long, Boolean> {
    public static final String TAG = DownloadTask.class.getSimpleName();
    public static final int BUFFER_UNIT = 524288;
    public static final String DEFAULT_BOUNDARY = "----7d4261b4f3";
    private Context context;
    private CheckResult.Update.File file;
    private DownloadCallback callback;
    private Handler mainHandler;
    private boolean isStoped = false;

    public DownloadTask(@NonNull Context context, @NonNull CheckResult.Update.File file, @NonNull DownloadCallback callback) {
        this.context = context.getApplicationContext();
        this.file = file;
        this.callback = callback;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    public synchronized void stop() {
        this.isStoped = true;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.callback.onStart(this.file.getFileId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Boolean doInBackground(String ... params) {
        final String fileId = this.file.getFileId();
        String billInfo = params[1];
        if (TextUtils.isEmpty((CharSequence)fileId)) {
            Log.d((String)TAG, (String)"============fileId\u4e3a\u7a7a================");
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DownloadTask.this.callback.onError(fileId, "fileId\u4e3a\u7a7a", null);
                }
            });
            return false;
        }
        RandomAccessFile randomAccessFile = null;
        File targetFile = new File(this.context.getFilesDir() + "/" + fileId + ".apk");
        try {
            long offset = this.getOffset(targetFile);
            if (offset >= this.file.getfSize() - 1L) {
                Log.d((String)TAG, (String)"=======\u6587\u4ef6\u5df2\u4e0b\u8f7d\u5b8c\u6210======");
                if (this.verifyFile(targetFile, this.file.getCheckCode())) {
                    Boolean bl = true;
                    return bl;
                }
                this.runOnMainThread(new Runnable(){

                    @Override
                    public void run() {
                        DownloadTask.this.callback.onError(fileId, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25", null);
                    }
                });
                Boolean bl = false;
                return bl;
            }
            long endIndex = this.getEndIndex(offset);
            randomAccessFile = new RandomAccessFile(targetFile, "rws");
            randomAccessFile.seek(offset);
            StringBuffer sb = this.getMultipartBody(fileId, billInfo);
            URL url = new URL(params[0] + "/httpgetfile.do?");
            while (!this.isStoped) {
                HttpURLConnection conn = this.getHttpURLConnection(offset, endIndex, sb, url);
                final int responseCode = conn.getResponseCode();
                if (responseCode != 200 && responseCode != 206) {
                    Log.d((String)TAG, (String)("============\u670d\u52a1\u5668\u54cd\u5e94\u9519\u8bef\uff0c\u54cd\u5e94\u7801\uff1a" + responseCode + "================"));
                    this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            DownloadTask.this.callback.onError(fileId, "\u670d\u52a1\u5668\u54cd\u5e94\u9519\u8bef\uff0c\u54cd\u5e94\u7801\uff1a" + responseCode, null);
                        }
                    });
                    Boolean bl = false;
                    return bl;
                }
                InputStream is = conn.getInputStream();
                if (is == null) {
                    Log.d((String)TAG, (String)"============\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519================");
                    this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            DownloadTask.this.callback.onError(fileId, "\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519", null);
                        }
                    });
                    Boolean bl = false;
                    return bl;
                }
                this.appendStream(randomAccessFile, is);
                this.publishProgress(new Long[]{endIndex + 1L});
                offset = endIndex + 1L;
                if (offset >= this.file.getfSize() - 1L) {
                    Log.d((String)TAG, (String)"=======\u6587\u4ef6\u5df2\u4e0b\u8f7d\u5b8c\u6210======");
                    if (this.verifyFile(targetFile, this.file.getCheckCode())) {
                        Boolean bl = true;
                        return bl;
                    }
                    this.runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            DownloadTask.this.callback.onError(fileId, "\u6587\u4ef6\u6821\u9a8c\u5931\u8d25", null);
                        }
                    });
                    Boolean bl = false;
                    return bl;
                }
                endIndex = this.getEndIndex(offset);
                randomAccessFile.seek(offset);
            }
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DownloadTask.this.callback.onStop(DownloadTask.this.file.getfName());
                }
            });
            Boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("=============\r\n\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519 : " + e.getMessage() + "\r\n=============="));
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DownloadTask.this.callback.onError(fileId, "\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519 : " + e.getMessage(), e);
                }
            });
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void onProgressUpdate(Long ... values) {
        super.onProgressUpdate((Object[])values);
        this.callback.onProgress(this.file.getFileId(), this.file.getfSize(), values[0]);
    }

    protected void onPostExecute(Boolean result) {
        super.onPostExecute((Object)result);
        if (result.booleanValue()) {
            this.callback.onComplete(this.file.getFileId());
        }
    }

    private void appendStream(RandomAccessFile randomAccessFile, InputStream is) throws IOException {
        byte[] buffer = new byte[524288];
        int count = -1;
        while ((count = is.read(buffer, 0, 524288)) != -1) {
            randomAccessFile.write(buffer, 0, count);
        }
        is.close();
    }

    @NonNull
    private HttpURLConnection getHttpURLConnection(long offset, long endIndex, StringBuffer sb, URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setConnectTimeout(15000);
        conn.setReadTimeout(15000);
        conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=----7d4261b4f3");
        conn.setRequestProperty("Connection", "Keep-Alive");
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Range", "bytes=" + offset + "-" + endIndex);
        OutputStream outputStream = conn.getOutputStream();
        outputStream.write(sb.toString().getBytes("UTF-8"));
        outputStream.flush();
        return conn;
    }

    @NonNull
    private StringBuffer getMultipartBody(String fileId, String billInfo) {
        return new StringBuffer().append("--").append(DEFAULT_BOUNDARY).append("\r\n").append("Content-Disposition:form-data;name=\"fileId\"").append("\r\n\r\n").append(fileId).append("\r\n").append("--").append(DEFAULT_BOUNDARY).append("\r\n").append("Content-Disposition:form-data;name=\"billInfo\"").append("\r\n\r\n").append(TextUtils.isEmpty((CharSequence)billInfo) ? "" : billInfo).append("\r\n").append("--").append(DEFAULT_BOUNDARY).append("--").append("\r\n");
    }

    private long getEndIndex(long offset) {
        long endIndex = 0L;
        long l = this.file.getfSize() - 1L - offset;
        endIndex = l >= (long)this.callback.unit() ? offset + (long)this.callback.unit() : this.file.getfSize() - 1L;
        return endIndex;
    }

    private long getOffset(File of) throws IOException {
        long offset = 0L;
        if (!of.exists()) {
            if (!of.createNewFile()) {
                Log.d((String)TAG, (String)"============\u6587\u4ef6\u521b\u5efa\u5931\u8d25================");
            }
        } else {
            offset = of.length() - 1L;
        }
        return offset;
    }

    private boolean verifyFile(File file, String except) {
        String actual = EncryptUtils.encryptMD5File2String(file).toLowerCase();
        return actual.equals(except.toLowerCase());
    }

    private void runOnMainThread(Runnable runnable) {
        this.mainHandler.post(runnable);
    }
}

