/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.util.Log;
import com.xdja.update.CheckCallback;
import com.xdja.update.CheckTask;
import com.xdja.update.DownloadCallback;
import com.xdja.update.DownloadTask;
import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class UpdateManager {
    public static final String TAG = UpdateManager.class.getSimpleName();
    private static UpdateManager INSTANCE;
    private Executor exec;
    private Context context;
    private String baseUrl;
    private CheckTask checkTask;
    private DownloadTask downloadTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<UpdateManager> clazz = UpdateManager.class;
        synchronized (UpdateManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new UpdateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private UpdateManager() {
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public void install(@NonNull Context context) {
        this.context = context.getApplicationContext();
        this.exec = Executors.newSingleThreadScheduledExecutor();
    }

    public void uninstall() {
        this.context = null;
        this.exec = null;
        this.checkTask = null;
        this.downloadTask = null;
        this.baseUrl = null;
    }

    public void stopDownload() {
        if (this.downloadTask != null && this.downloadTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.downloadTask.stop();
        }
    }

    public void checkUpdate(@NonNull CheckCallback checkCallback) {
        if (this.isBusy()) {
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u4efb\u52a1\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u5373\u5c06\u5f00\u59cb=======");
        this.checkTask = new CheckTask(this.context, checkCallback);
        this.checkTask.executeOnExecutor(this.exec, new String[]{"ClientVer.xml"});
    }

    public void checkUpdate(@NonNull CheckCallback checkCallback, @NonNull CheckProtocol checkProtocol) {
        if (this.isBusy()) {
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u4efb\u52a1\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u5373\u5c06\u5f00\u59cb=======");
        this.checkTask = new CheckTask(this.context, checkProtocol, checkCallback);
        this.checkTask.executeOnExecutor(this.exec, new String[0]);
    }

    public void downloadFile(CheckResult.Update.File file, DownloadCallback callback) {
        if (this.downloadTask != null && this.downloadTask.getStatus() != AsyncTask.Status.FINISHED) {
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u4e0b\u8f7d\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u4e0b\u8f7d\u5373\u5c06\u5f00\u59cb=======");
        this.downloadTask = new DownloadTask(this.context, file, callback);
        this.downloadTask.executeOnExecutor(this.exec, new String[]{this.getBaseUrl(), ""});
    }

    private boolean isBusy() {
        return this.checkTask != null && this.checkTask.getStatus() != AsyncTask.Status.FINISHED || this.downloadTask != null && this.downloadTask.getStatus() != AsyncTask.Status.FINISHED;
    }
}

