/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.update.CheckCallback;
import com.xdja.update.DelegateCheckCallback;
import com.xdja.update.R;
import com.xdja.update.U;
import com.xdja.update.UpdateManager;
import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.CheckUpdateError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class CheckTask<T>
extends AsyncTask<T, Integer, CheckResult> {
    private final String TAG = CheckTask.class.getSimpleName();
    private final String DOC_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final String CHECK_UPDATE_PROJECT_NAME = "/Update/update/httpupdate.do";
    private final String tag_req = "Req";
    private final String tag_result = "Result";
    private final String tag_mod_power = "ModPower";
    private final String tag_msg = "Msg";
    private final String tag_root = "Root";
    private final String tag_server_ip = "ServerIP";
    private final String tag_server_port = "ServerPort";
    private final String tag_factory = "Factory";
    private final String tag_os = "OS";
    private final String tag_mod = "Mod";
    private final String tag_soft = "Soft";
    private final String tag_username = "UserName";
    private final String tag_ver = "Ver";
    private final String tag_update = "Update";
    private final String tag_verType = "VerType";
    private final String tag_version = "Version";
    private final String tag_date = "Date";
    private final String tag_comment = "Comment";
    private final String tag_updateTag = "UpdateTag";
    private final String tag_files = "Files";
    private final String tag_file = "File";
    private final String tag_rPath = "RPath";
    private final String tag_lPath = "LPath";
    private final String tag_fName = "FName";
    private final String tag_fSize = "FSize";
    private final String tag_action = "Action";
    private final String tag_state = "State";
    private final String tag_cSize = "CSize";
    private final String tag_checkCode = "CheckCode";
    private final String tag_deleteDb = "DeleteDb";
    private final String tag_fileId = "FileId";
    @SuppressLint(value={"StaticFieldLeak"})
    @NonNull
    private final Context cxt;
    @NonNull
    private final CheckCallback checkCallback;
    @NonNull
    private final UpdateManager.AccessConfig accessConfig;

    CheckTask(@NonNull Context context, @NonNull CheckCallback callback, @NonNull UpdateManager.AccessConfig accessConfig) {
        if (context instanceof Activity) {
            throw new RuntimeException("the context can not be ActivityContext,It must be a ApplicationContext");
        }
        this.cxt = context;
        this.checkCallback = new DelegateCheckCallback(callback);
        this.accessConfig = accessConfig;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.checkCallback.onChecking();
    }

    @RequiresApi(api=3)
    protected void onPostExecute(CheckResult result) {
        super.onPostExecute((Object)result);
        if (!this.isCancelled()) {
            if (result != null) {
                this.checkCallback.onCheckResult(result);
            } else {
                this.checkCallback.onCheckResult(this.buildErrorCheckResult(this.cxt.getString(R.string.error_unknown), CheckUpdateError.CHECK_UNKNOW_ERROR));
            }
        }
    }

    @SafeVarargs
    protected final CheckResult doInBackground(T ... params) {
        String result;
        CheckProtocol protocol;
        Log.d((String)this.TAG, (String)("===== doInBackground thread\u3000: ThreadGroup = " + Thread.currentThread().getThreadGroup().getName() + ";ThreadName = " + Thread.currentThread().getName() + ";ThreadId = " + Thread.currentThread().getId() + "====="));
        if (params == null || params[0] == null) {
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_server_request_param), CheckUpdateError.CHECK_REQUEST_PARAMETER_ERROR);
        }
        T param = params[0];
        if (CheckProtocol.class.isAssignableFrom(param.getClass())) {
            protocol = (CheckProtocol)param;
        } else {
            try {
                protocol = this.buildCheckProtocol((String)param);
            }
            catch (IOException | XmlPullParserException e) {
                return this.buildErrorCheckResult(this.cxt.getString(R.string.error_access_config) + e.getMessage(), CheckUpdateError.CHECK_CONFIG_ERROR);
            }
        }
        if (protocol == null) {
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_server_request_param), CheckUpdateError.CHECK_REQUEST_PARAMETER_ERROR);
        }
        this.accessConfig.setBaseUrl("http://" + protocol.getServerIp() + ":" + protocol.getServerPort());
        try {
            String protocolStr = protocol.toString();
            Log.d((String)this.TAG, (String)("\u68c0\u6d4b\u5347\u7ea7\u8bf7\u6c42\u53c2\u6570 : \r\n" + protocolStr));
            result = U.HttpUtils.postString(this.accessConfig.getBaseUrl() + "/Update/update/httpupdate.do", protocolStr);
            Log.d((String)this.TAG, (String)("\u5347\u7ea7\u8bf7\u6c42\u7ed3\u679c\u4e3a \uff1a " + result));
        }
        catch (Exception e) {
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_update_request) + e.getMessage(), CheckUpdateError.CHECK_UPDATE_ERROR);
        }
        if (TextUtils.isEmpty((CharSequence)result)) {
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_server_data_empty), CheckUpdateError.CHECK_DATA_ERROR);
        }
        return this.buildCheckResult(result);
    }

    private CheckResult buildCheckResult(String result) {
        String updateResult;
        int firstIndex = result.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        int lastIndex = result.lastIndexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        String updateContent = null;
        if (firstIndex == lastIndex) {
            updateResult = result;
        } else {
            updateResult = result.substring(firstIndex, lastIndex);
            updateContent = result.substring(lastIndex);
        }
        Log.d((String)this.TAG, (String)("updateResult : " + updateResult + "\r\nupdateContent : " + updateContent));
        try {
            if (!TextUtils.isEmpty((CharSequence)updateResult)) {
                XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
                CheckResult checkResult = this.resolveUpdateResult(updateResult, parserFactory);
                if (!TextUtils.isEmpty((CharSequence)updateContent) && checkResult != null) {
                    checkResult.setUpdates(this.resolveUpdateContent(updateContent, parserFactory));
                }
                return checkResult;
            }
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_server_data_cannot_use), CheckUpdateError.CHECK_SERVER_ERROR);
        }
        catch (IOException | XmlPullParserException e) {
            return this.buildErrorCheckResult(this.cxt.getString(R.string.error_server_data_cannot_access) + e.getMessage(), CheckUpdateError.CHECK_DATA_ERROR);
        }
    }

    private CheckProtocol buildCheckProtocol(@NonNull String updateConfig) throws IOException, XmlPullParserException {
        InputStream open = this.cxt.getAssets().open(updateConfig);
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput(open, "UTF-8");
        int eventType = parser.getEventType();
        CheckProtocol protocol = null;
        ArrayList<CheckProtocol.Ver> vers = null;
        CheckProtocol.Ver ver = null;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String name = parser.getName();
                    if ("Root".equals(name)) {
                        protocol = new CheckProtocol();
                        if (this.accessConfig.isAppSelfish()) {
                            protocol.setSoft(U.AppUtils.getAppName(this.cxt));
                        }
                        if (!TextUtils.isEmpty((CharSequence)this.accessConfig.getCardNo())) {
                            protocol.setCardNo(this.accessConfig.getCardNo());
                        }
                        if (!this.accessConfig.isSubstitute()) break;
                        if (!TextUtils.isEmpty((CharSequence)this.accessConfig.getIp())) {
                            protocol.setServerIp(this.accessConfig.getIp());
                        }
                        if (TextUtils.isEmpty((CharSequence)this.accessConfig.getPort())) break;
                        protocol.setServerPort(this.accessConfig.getPort());
                        break;
                    }
                    if ("ServerIP".equals(name)) {
                        if (this.accessConfig.isSubstitute() || protocol == null) break;
                        protocol.setServerIp(parser.nextText());
                        break;
                    }
                    if ("ServerPort".equals(name)) {
                        if (this.accessConfig.isSubstitute() || protocol == null) break;
                        protocol.setServerPort(parser.nextText());
                        break;
                    }
                    if ("Factory".equals(name)) {
                        if (protocol == null) break;
                        protocol.setFactory(parser.nextText());
                        break;
                    }
                    if ("OS".equals(name)) {
                        if (protocol == null) break;
                        protocol.setOs(parser.nextText());
                        break;
                    }
                    if ("Mod".equals(name)) {
                        if (protocol == null) break;
                        protocol.setMod(parser.nextText());
                        break;
                    }
                    if ("Soft".equals(name)) {
                        if (this.accessConfig.isAppSelfish() || protocol == null) break;
                        protocol.setSoft(parser.nextText());
                        break;
                    }
                    if ("UserName".equals(name)) {
                        if (protocol == null) break;
                        protocol.setUserName(parser.nextText());
                        break;
                    }
                    if ("Ver".equals(name)) {
                        if (vers == null) {
                            vers = new ArrayList<CheckProtocol.Ver>();
                        }
                        ver = new CheckProtocol.Ver();
                        if (!this.accessConfig.isAppSelfish()) break;
                        ver.setVerName(U.AppUtils.getAppVersionName(this.cxt));
                        ver.setVerType(U.AppUtils.getAppPackageName(this.cxt));
                        break;
                    }
                    if ("Version".equals(name)) {
                        if (this.accessConfig.isAppSelfish() || ver == null) break;
                        ver.setVerName(parser.nextText());
                        break;
                    }
                    if ("Date".equals(name)) {
                        if (ver == null) break;
                        ver.setDate(parser.nextText());
                        break;
                    }
                    if (!"VerType".equals(name) || this.accessConfig.isAppSelfish() || ver == null) break;
                    ver.setVerType(parser.nextText());
                    break;
                }
                case 3: {
                    String endName = parser.getName();
                    if ("Ver".equals(endName)) {
                        if (vers == null) break;
                        vers.add(ver);
                        break;
                    }
                    if (!"Root".equals(endName) || protocol == null) break;
                    protocol.setVers((List<CheckProtocol.Ver>)vers);
                    break;
                }
            }
            eventType = parser.next();
        }
        return protocol;
    }

    private CheckResult resolveUpdateResult(String updateResult, XmlPullParserFactory parserFactory) throws XmlPullParserException, IOException {
        CheckResult checkResult = null;
        XmlPullParser parser = parserFactory.newPullParser();
        parser.setInput((Reader)new StringReader(updateResult));
        int eventType = parser.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 0: {
                    checkResult = new CheckResult();
                    break;
                }
                case 2: {
                    if (checkResult == null) break;
                    String name = parser.getName();
                    if ("Req".equals(name)) {
                        checkResult.setReq(parser.nextText());
                        break;
                    }
                    if ("Result".equals(name)) {
                        checkResult.setResult(parser.nextText());
                        break;
                    }
                    if ("ModPower".equals(name)) {
                        checkResult.setModPower(parser.nextText());
                        break;
                    }
                    if (!"Msg".equals(name)) break;
                    checkResult.setMsg(parser.nextText());
                    break;
                }
            }
            eventType = parser.next();
        }
        return checkResult;
    }

    private List<CheckResult.Update> resolveUpdateContent(String updateContent, XmlPullParserFactory parserFactory) throws XmlPullParserException, IOException {
        XmlPullParser pullParser = parserFactory.newPullParser();
        pullParser.setInput((Reader)new StringReader(updateContent));
        ArrayList<CheckResult.Update> updates = null;
        CheckResult.Update update = null;
        ArrayList<CheckResult.Update.File> files = null;
        CheckResult.Update.File file = null;
        int event = pullParser.getEventType();
        while (event != 1) {
            switch (event) {
                case 0: {
                    updates = new ArrayList<CheckResult.Update>();
                    break;
                }
                case 2: {
                    String name = pullParser.getName();
                    if ("Update".equals(name)) {
                        update = new CheckResult.Update();
                        break;
                    }
                    if ("VerType".equals(name)) {
                        if (update == null) break;
                        update.setVerType(pullParser.nextText());
                        break;
                    }
                    if ("Version".equals(name)) {
                        if (update == null) break;
                        update.setVersion(pullParser.nextText());
                        break;
                    }
                    if ("Date".equals(name)) {
                        if (update == null) break;
                        update.setDate(pullParser.nextText());
                        break;
                    }
                    if ("Comment".equals(name)) {
                        if (update == null) break;
                        update.setComment(pullParser.nextText());
                        break;
                    }
                    if ("UpdateTag".equals(name)) {
                        if (update == null) break;
                        update.setUpdateTag(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if ("Files".equals(name)) {
                        files = new ArrayList<CheckResult.Update.File>();
                        break;
                    }
                    if ("File".equals(name)) {
                        file = new CheckResult.Update.File();
                        break;
                    }
                    if ("RPath".equals(name)) {
                        if (file == null) break;
                        file.setrPath(pullParser.nextText());
                        break;
                    }
                    if ("LPath".equals(name)) {
                        if (file == null) break;
                        file.setlPath(pullParser.nextText());
                        break;
                    }
                    if ("FName".equals(name)) {
                        if (file == null) break;
                        file.setfName(pullParser.nextText());
                        break;
                    }
                    if ("FSize".equals(name)) {
                        if (file == null) break;
                        file.setfSize(Long.parseLong(pullParser.nextText()));
                        break;
                    }
                    if ("Action".equals(name)) {
                        if (file == null) break;
                        file.setAction(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if ("State".equals(name)) {
                        if (file == null) break;
                        file.setState(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if ("CSize".equals(name)) {
                        if (file == null) break;
                        file.setcSize(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if ("CheckCode".equals(name)) {
                        if (file == null) break;
                        file.setCheckCode(pullParser.nextText());
                        break;
                    }
                    if ("DeleteDb".equals(name)) {
                        if (file == null) break;
                        file.setDeleteDb(Integer.parseInt(pullParser.nextText()));
                        break;
                    }
                    if (!"FileId".equals(name) || file == null) break;
                    file.setFileId(pullParser.nextText());
                    break;
                }
                case 3: {
                    String endName = pullParser.getName();
                    if ("File".equals(endName)) {
                        if (files == null) break;
                        files.add(file);
                        break;
                    }
                    if ("Files".equals(endName)) {
                        if (update == null) break;
                        update.setFiles((List<CheckResult.Update.File>)files);
                        break;
                    }
                    if (!"Update".equals(endName) || updates == null) break;
                    updates.add(update);
                    break;
                }
            }
            event = pullParser.next();
        }
        return updates;
    }

    private CheckResult buildErrorCheckResult(String msg, CheckUpdateError checkUpdateError) {
        CheckResult checkResult = new CheckResult();
        checkResult.setResult("-1");
        checkResult.setMsg(msg);
        checkResult.setCheckUpdateError(checkUpdateError);
        return checkResult;
    }
}

