package com.xdja.update;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.CheckUpdateError;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/**
 * <P>description : 检测升级任务 </P>
 * <P>className : CheckTask </P>
 * <P>package : com.xdja.update </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 10:26 </P>
 *
 * @author fjd
 */
@SuppressWarnings("FieldCanBeLocal")
class CheckTask<T> extends AsyncTask<T, Integer, CheckResult> {

    private final String TAG = CheckTask.class.getSimpleName();
    private final String DOC_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private final String CHECK_UPDATE_PROJECT_NAME = "/Update/update/httpupdate.do";

    private final String tag_req = "Req";
    private final String tag_result = "Result";
    private final String tag_mod_power = "ModPower";
    private final String tag_msg = "Msg";

    private final String tag_root = "Root";
    private final String tag_server_ip = "ServerIP";
    private final String tag_server_port = "ServerPort";
    private final String tag_factory = "Factory";
    private final String tag_os = "OS";
    private final String tag_mod = "Mod";
    private final String tag_soft = "Soft";
    private final String tag_username = "UserName";
    private final String tag_ver = "Ver";
    ///private final String tag_version = "Version";
    ///private final String tag_date = "Date";
    //private final String tag_verType = "VerType";

    private final String tag_update = "Update";
    private final String tag_verType = "VerType";
    private final String tag_version = "Version";
    private final String tag_date = "Date";
    private final String tag_comment = "Comment";
    private final String tag_updateTag = "UpdateTag";
    private final String tag_files = "Files";
    private final String tag_file = "File";
    private final String tag_rPath = "RPath";
    private final String tag_lPath = "LPath";
    private final String tag_fName = "FName";
    private final String tag_fSize = "FSize";
    private final String tag_action = "Action";
    private final String tag_state = "State";
    private final String tag_cSize = "CSize";
    private final String tag_checkCode = "CheckCode";
    private final String tag_deleteDb = "DeleteDb";
    private final String tag_fileId = "FileId";

    @SuppressLint("StaticFieldLeak")
    @NonNull
    private final Context cxt;

    @NonNull
    private final CheckCallback checkCallback;

    @NonNull
    private final UpdateManager.AccessConfig accessConfig;


    /**
     * Instantiates a new CheckTask
     *
     * @param context      Context上下文（必须为Application级别的上下文）
     * @param callback     检测升级回调接口
     * @param accessConfig 初始化配置信息
     */
    CheckTask(@NonNull Context context,
              @NonNull CheckCallback callback,
              @NonNull UpdateManager.AccessConfig accessConfig) {
        if (context instanceof Activity) {
            throw new RuntimeException("the context can not be ActivityContext,It must be a ApplicationContext");
        }
        this.cxt = context;
        this.checkCallback = new DelegateCheckCallback(callback);
        this.accessConfig = accessConfig;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        this.checkCallback.onChecking();
    }

    @RequiresApi(api = Build.VERSION_CODES.CUPCAKE)
    @Override
    protected void onPostExecute(CheckResult result) {
        super.onPostExecute(result);
        if (!isCancelled()) {
            if (result != null) {
                this.checkCallback.onCheckResult(result);
            } else {
                this.checkCallback.onCheckResult(
                        buildErrorCheckResult(
                                cxt.getString(R.string.error_unknown),
                                CheckUpdateError.CHECK_UNKNOW_ERROR
                        )
                );
            }
        }
    }

    @SafeVarargs
    @Override
    protected final CheckResult doInBackground(T... params) {

        Log.d(TAG, "===== doInBackground thread　: ThreadGroup = "
                + Thread.currentThread().getThreadGroup().getName()
                + ";ThreadName = "
                + Thread.currentThread().getName()
                + ";ThreadId = "
                + Thread.currentThread().getId() + "=====");

        if (params == null || params[0] == null) {
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_server_request_param),
                    CheckUpdateError.CHECK_REQUEST_PARAMETER_ERROR
            );
        }

        T param = params[0];

        CheckProtocol protocol;

        //使用调用方传入的检测升级相关信息
        if (CheckProtocol.class.isAssignableFrom(param.getClass())) {
            protocol = ((CheckProtocol) param);

        } else {
            //调用方未传入检测升级相关信息，程序自己进行构建
            try {
                //构建检测升级协议对象（从ClientVersion.xml中读取）
                protocol = buildCheckProtocol(((String) param));
            } catch (IOException | XmlPullParserException e) {
                return buildErrorCheckResult(
                        cxt.getString(R.string.error_access_config) + e.getMessage(),
                        CheckUpdateError.CHECK_CONFIG_ERROR
                );
            }
        }

        if (protocol == null
                || TextUtils.isEmpty(protocol.getServerIp())
                || TextUtils.isEmpty(protocol.getServerPort())) {
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_server_request_param),
                    CheckUpdateError.CHECK_REQUEST_PARAMETER_ERROR
            );
        }
        String baseUrl = null;
        if (protocol.getServerIp().startsWith("http")) {
            baseUrl = protocol.getServerIp() + ":" + protocol.getServerPort();
        } else {
            baseUrl = this.accessConfig.getSchemeStr() + "://" + protocol.getServerIp() + ":" + protocol.getServerPort();
        }
        //从读取到的信息中获取Ip地址和端口号，构建baseUrl
        this.accessConfig.setBaseUrl(baseUrl);
        String result;
        try {
            String protocolStr = protocol.toString();
            Log.d(TAG, "检测升级请求参数 : \r\n" + protocolStr);
            //检测升级
            result = U.HttpUtils.postString(this.accessConfig.getBaseUrl() + CHECK_UPDATE_PROJECT_NAME,
                    protocolStr,
                    U.MySSLSocketFactory.getSocketFactory(cxt, this.accessConfig.getCertName(), this.accessConfig.getPass())
            );
            Log.d(TAG, "升级请求结果为 ： " + result);
        } catch (Exception e) {
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_update_request) + e.getMessage(),
                    CheckUpdateError.CHECK_UPDATE_ERROR
            );
        }

        if (TextUtils.isEmpty(result)) {
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_server_data_empty),
                    CheckUpdateError.CHECK_DATA_ERROR
            );
        }
        return buildCheckResult(result);
    }


    private CheckResult buildCheckResult(String result) {
        //解析升级检测结果
        int firstIndex = result.indexOf(DOC_HEADER);
        int lastIndex = result.lastIndexOf(DOC_HEADER);
        String updateResult;
        String updateContent = null;
        if (firstIndex == lastIndex) {
            updateResult = result;
        } else {
            updateResult = result.substring(firstIndex, lastIndex);
            updateContent = result.substring(lastIndex);
        }
        Log.d(TAG, "updateResult : " + updateResult + "\r\nupdateContent : " + updateContent);

        try {
            if (!TextUtils.isEmpty(updateResult)) {
                XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
                CheckResult checkResult = resolveUpdateResult(updateResult, parserFactory);
                if (!TextUtils.isEmpty(updateContent) && checkResult != null) {
                    checkResult.setUpdates(resolveUpdateContent(updateContent, parserFactory));
                }
                return checkResult;
            }
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_server_data_cannot_use),
                    CheckUpdateError.CHECK_SERVER_ERROR
            );
        } catch (XmlPullParserException | IOException e) {
            return buildErrorCheckResult(
                    cxt.getString(R.string.error_server_data_cannot_access) + e.getMessage(),
                    CheckUpdateError.CHECK_DATA_ERROR
            );
        }
    }

    private CheckProtocol buildCheckProtocol(@NonNull String updateConfig)
            throws IOException, XmlPullParserException {
        InputStream open = this.cxt.getAssets().open(updateConfig);
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setInput(open, "UTF-8");
        int eventType = parser.getEventType();

        CheckProtocol protocol = null;
        List<CheckProtocol.Ver> vers = null;
        CheckProtocol.Ver ver = null;


        while (eventType != XmlPullParser.END_DOCUMENT) {
            switch (eventType) {
                case XmlPullParser.START_TAG:
                    String name = parser.getName();
                    if (tag_root.equals(name)) {
                        protocol = new CheckProtocol();
                        if (accessConfig.isAppSelfish()) {
                            protocol.setSoft(U.AppUtils.getAppName(this.cxt));
                        }
                        if (!TextUtils.isEmpty(accessConfig.getCardNo())) {
                            protocol.setCardNo(accessConfig.getCardNo());
                        }
                        if (accessConfig.isSubstitute()) {
                            if (!TextUtils.isEmpty(accessConfig.getIp())) {
                                protocol.setServerIp(accessConfig.getIp());
                            }
                            if (!TextUtils.isEmpty(accessConfig.getPort())) {
                                protocol.setServerPort(accessConfig.getPort());
                            }
                        }
                    } else if (tag_server_ip.equals(name)) {
                        if (!accessConfig.isSubstitute()) {
                            if (protocol != null) {
                                protocol.setServerIp(parser.nextText());
                            }
                        }
                    } else if (tag_server_port.equals(name)) {
                        if (!accessConfig.isSubstitute()) {
                            if (protocol != null) {
                                protocol.setServerPort(parser.nextText());
                            }
                        }
                    } else if (tag_factory.equals(name)) {
                        if (protocol != null) {
                            protocol.setFactory(parser.nextText());
                        }
                    } else if (tag_os.equals(name)) {
                        if (protocol != null) {
                            protocol.setOs(parser.nextText());
                        }
                    } else if (tag_mod.equals(name)) {
                        if (protocol != null) {
                            protocol.setMod(parser.nextText());
                        }
                    } else if (tag_soft.equals(name)) {
                        if (!accessConfig.isAppSelfish()) {
                            if (protocol != null) {
                                protocol.setSoft(parser.nextText());
                            }
                        }
                    } else if (tag_username.equals(name)) {
                        if (protocol != null) {
                            protocol.setUserName(parser.nextText());
                        }
                    } else if (tag_ver.equals(name)) {
                        if (vers == null) {
                            vers = new ArrayList<>();
                        }
                        ver = new CheckProtocol.Ver();
                        if (accessConfig.isAppSelfish()) {
                            ver.setVerName(U.AppUtils.getAppVersionName(this.cxt));
                            ver.setVerType(U.AppUtils.getAppPackageName(this.cxt));
                        }
                    } else if (tag_version.equals(name)) {
                        if (!accessConfig.isAppSelfish()) {
                            if (ver != null) {
                                ver.setVerName(parser.nextText());
                            }
                        }
                    } else if (tag_date.equals(name)) {
                        if (ver != null) {
                            ver.setDate(parser.nextText());
                        }
                    } else if (tag_verType.equals(name)) {
                        if (!accessConfig.isAppSelfish()) {
                            if (ver != null) {
                                ver.setVerType(parser.nextText());
                            }
                        }
                    }
                    break;
                case XmlPullParser.END_TAG:
                    String endName = parser.getName();
                    if (tag_ver.equals(endName)) {
                        if (vers != null) {
                            vers.add(ver);
                        }
                    } else if (tag_root.equals(endName)) {
                        if (protocol != null) {
                            protocol.setVers(vers);
                        }
                    }
                    break;
                default:
                    break;
            }
            eventType = parser.next();
        }
        return protocol;
    }

    private CheckResult resolveUpdateResult(String updateResult, XmlPullParserFactory parserFactory)
            throws XmlPullParserException, IOException {
        CheckResult checkResult = null;

        XmlPullParser parser = parserFactory.newPullParser();
        parser.setInput(new StringReader(updateResult));

        int eventType = parser.getEventType();
        while (eventType != XmlPullParser.END_DOCUMENT) {
            switch (eventType) {
                case XmlPullParser.START_DOCUMENT:
                    checkResult = new CheckResult();
                    break;
                case XmlPullParser.START_TAG:
                    if (checkResult != null) {
                        String name = parser.getName();
                        if (tag_req.equals(name)) {
                            checkResult.setReq(parser.nextText());
                        } else if (tag_result.equals(name)) {
                            checkResult.setResult(parser.nextText());
                        } else if (tag_mod_power.equals(name)) {
                            checkResult.setModPower(parser.nextText());
                        } else if (tag_msg.equals(name)) {
                            checkResult.setMsg(parser.nextText());
                        }
                    }
                    break;
                default:
                    break;
            }
            eventType = parser.next();
        }
        return checkResult;
    }

    private List<CheckResult.Update> resolveUpdateContent(String updateContent, XmlPullParserFactory parserFactory)
            throws XmlPullParserException, IOException {
        XmlPullParser pullParser = parserFactory.newPullParser();
        pullParser.setInput(new StringReader(updateContent));

        List<CheckResult.Update> updates = null;
        CheckResult.Update update = null;
        List<CheckResult.Update.File> files = null;
        CheckResult.Update.File file = null;

        int event = pullParser.getEventType();
        while (event != XmlPullParser.END_DOCUMENT) {
            switch (event) {
                case XmlPullParser.START_DOCUMENT:
                    updates = new ArrayList<>();
                    break;
                case XmlPullParser.START_TAG:
                    String name = pullParser.getName();
                    if (tag_update.equals(name)) {
                        update = new CheckResult.Update();
                    } else if (tag_verType.equals(name)) {
                        if (update != null) {
                            update.setVerType(pullParser.nextText());
                        }
                    } else if (tag_version.equals(name)) {
                        if (update != null) {
                            update.setVersion(pullParser.nextText());
                        }
                    } else if (tag_date.equals(name)) {
                        if (update != null) {
                            update.setDate(pullParser.nextText());
                        }
                    } else if (tag_comment.equals(name)) {
                        if (update != null) {
                            update.setComment(pullParser.nextText());
                        }
                    } else if (tag_updateTag.equals(name)) {
                        if (update != null) {
                            update.setUpdateTag(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (tag_files.equals(name)) {
                        files = new ArrayList<>();
                    } else if (tag_file.equals(name)) {
                        file = new CheckResult.Update.File();
                    } else if (tag_rPath.equals(name)) {
                        if (file != null) {
                            file.setrPath(pullParser.nextText());
                        }
                    } else if (tag_lPath.equals(name)) {
                        if (file != null) {
                            file.setlPath(pullParser.nextText());
                        }
                    } else if (tag_fName.equals(name)) {
                        if (file != null) {
                            file.setfName(pullParser.nextText());
                        }
                    } else if (tag_fSize.equals(name)) {
                        if (file != null) {
                            file.setfSize(Long.parseLong(pullParser.nextText()));
                        }
                    } else if (tag_action.equals(name)) {
                        if (file != null) {
                            file.setAction(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (tag_state.equals(name)) {
                        if (file != null) {
                            file.setState(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (tag_cSize.equals(name)) {
                        if (file != null) {
                            file.setcSize(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (tag_checkCode.equals(name)) {
                        if (file != null) {
                            file.setCheckCode(pullParser.nextText());
                        }
                    } else if (tag_deleteDb.equals(name)) {
                        if (file != null) {
                            file.setDeleteDb(Integer.parseInt(pullParser.nextText()));
                        }
                    } else if (tag_fileId.equals(name)) {
                        if (file != null) {
                            file.setFileId(pullParser.nextText());
                        }
                    }
                    break;
                case XmlPullParser.END_TAG:
                    String endName = pullParser.getName();
                    if (tag_file.equals(endName)) {
                        if (files != null) {
                            files.add(file);
                        }
                    } else if (tag_files.equals(endName)) {
                        if (update != null) {
                            update.setFiles(files);
                        }
                    } else if (tag_update.equals(endName)) {
                        if (updates != null) {
                            updates.add(update);
                        }
                    }
                    break;
                default:
                    break;
            }
            event = pullParser.next();
        }
        return updates;
    }

    private CheckResult buildErrorCheckResult(String msg, CheckUpdateError checkUpdateError) {
        CheckResult checkResult = new CheckResult();
        checkResult.setResult(CheckResult.RESULT_UPDATE_ERROR);
        checkResult.setMsg(msg);
        checkResult.setCheckUpdateError(checkUpdateError);
        return checkResult;
    }
}
