package com.xdja.update;

import android.support.annotation.NonNull;

import com.xdja.update.bean.CheckResult;

/**
 * <P>description : DelegateCheckCallback </P>
 * <P>className : DelegateCheckCallback </P>
 * <P>package : com.xdja.update </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/21 16:14 </P>
 */
class DelegateCheckCallback implements CheckCallback {

    @NonNull
    private final CheckCallback checkCallback;

    DelegateCheckCallback(@NonNull CheckCallback checkCallback) {
        this.checkCallback = checkCallback;
    }

    @Override
    public void onChecking() {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                checkCallback.onChecking();
            }
        });
    }

    @Override
    public void onCheckResult(@NonNull final CheckResult checkResult) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                checkCallback.onCheckResult(checkResult);
            }
        });
    }
}
