package com.xdja.update;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.xdja.update.enums.DownLoadFileError;

/**
 * <P>description : DelegateDownloadCallback </P>
 * <P>className : DelegateDownloadCallback </P>
 * <P>package : com.xdja.update </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/21 16:58 </P>
 */
class DelegateDownloadCallback implements DownloadCallback {
    @NonNull
    private final DownloadCallback callback;

    DelegateDownloadCallback(@NonNull DownloadCallback downloadCallback) {
        this.callback = downloadCallback;
    }

    @Override
    public void onStart(@NonNull final String fileId) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                callback.onStart(fileId);
            }
        });
    }

    @Override
    public void onProgress(@NonNull final String fileId, final long totalSize, final long cSize) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                callback.onProgress(fileId, totalSize, cSize);
            }
        });
    }

    @Override
    public void onStop(@NonNull final String fileId) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                callback.onStop(fileId);
            }
        });
    }

    @Override
    public void onError(@NonNull final String fileId, @NonNull final DownLoadFileError error, @Nullable final Exception ex) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                callback.onError(fileId, error, ex);
            }
        });
    }

    @Override
    public void onComplete(@NonNull final String fileId, @NonNull final String filePath) {
        U.HandlerUtils.runOnMainThread(new Runnable() {
            @Override
            public void run() {
                callback.onComplete(fileId, filePath);
            }
        });
    }

    @Override
    public int unit() {
        return callback.unit();
    }

    @NonNull
    @Override
    public String downloadDir() {
        return callback.downloadDir();
    }
}
