package com.xdja.update;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.xdja.update.enums.DownLoadFileError;

/**
 * <P>description : 文件下载回调接口 </P>
 * <P>className : DownloadCallback </P>
 * <P>package : com.xdja.update </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 20:02 </P>
 * @author fjd
 */
public interface DownloadCallback {

    /**
     * 下载开始
     *
     * @param fileId 文件ID
     */
    void onStart(@NonNull String fileId);

    /**
     * 下载进度更新回调接口
     *
     * @param fileId    文件ID
     * @param totalSize 文件总大小
     * @param cSize     已下载大小
     */
    void onProgress(@NonNull String fileId, long totalSize, long cSize);

    /**
     * 下载已经停止
     *
     * @param fileId 文件ID
     */
    void onStop(@NonNull String fileId);

    /**
     * 下载发生错误
     *
     * @param fileId   文件ID
     * @param error 错误信息
     * @param ex       异常对象
     */
    void onError(@NonNull String fileId, @NonNull DownLoadFileError error,@Nullable Exception ex);

    /**
     * 下载完成
     *
     * @param fileId   文件ID
     * @param filePath 文件完整路径（如：升级文件的下载文件夹路径 + fileId +".apk"）
     */
    void onComplete(@NonNull String fileId, @NonNull String filePath);

    /**
     * 更新文件下载单元(单位：byte)
     *
     * @return 下载单元大小 int
     */
    int unit();

    /**
     * 设置升级文件的下载文件夹路径
     *
     * @return 升级文件的下载文件夹路径
     */
    @NonNull
    String downloadDir();
}
