package com.xdja.update;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

import static com.xdja.update.U.ConvertUtils.bytes2HexString;

/**
 * <P>description : 工具类集合</P>
 * <P>className : U </P>
 * <P>package : com.xdja.update </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 20:06 </P>
 */
class U {

    static class HandlerUtils{
        static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

        static void runOnMainThread(Runnable runnable) {
            MAIN_HANDLER.post(runnable);
        }
    }

    static class StringUtils {
        static String getEmptyIfNullOrBlank(@Nullable String nullableStr) {
            if (nullableStr == null || nullableStr.trim().length() == 0) {
                return "";
            }
            return nullableStr;
        }
        static String getNullIfNullOrBlank(@Nullable String nullableStr) {
            if (nullableStr == null || nullableStr.trim().length() == 0) {
                return null;
            }
            return nullableStr;
        }
    }

    /**
     * <P>description : http操作工具类 </P>
     * <P>className : HttpUtils </P>
     * <P>package : com.xdja.update.utils </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 20:01 </P>
     *
     * @author fjd
     */
    static class HttpUtils {

        private static final int HTTP_TIME_OUT = 20 * 1000;

        /**
         * POST方法获取http响应字符串
         *
         * @param address url地址
         * @param content 请求体内容
         * @param socketFactory 服务器证书名称
         * @return 响应内容
         */
        static String postString(String address, String content, SSLSocketFactory socketFactory) throws Exception {
            URL url = new URL(address);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection) connection).setSSLSocketFactory(socketFactory == null ? DefaultSSLSocketFactory.getSocketFactory() : socketFactory);
                ((HttpsURLConnection) connection).setHostnameVerifier(ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(HTTP_TIME_OUT);
            connection.setReadTimeout(HTTP_TIME_OUT);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("content-type", "text/html");
            connection.connect();

            OutputStream outputStream = connection.getOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(
                    new OutputStreamWriter(outputStream, Charset.forName("UTF-8"))
            );
            if (!TextUtils.isEmpty(content)) {
                bufferedWriter.write(content);
            }
            outputStream.flush();
            bufferedWriter.flush();
            outputStream.close();
            bufferedWriter.close();


            int responseCode = connection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                InputStream inputStream = connection.getInputStream();
                InputStreamReader reader = new InputStreamReader(inputStream);
                StringWriter stringWriter = new StringWriter();
                char[] cbuffer = new char[100];
                int readCount;
                while ((readCount = reader.read(cbuffer)) != -1) {
                    stringWriter.write(cbuffer, 0, readCount);
                }
                stringWriter.flush();
                inputStream.close();
                reader.close();
                stringWriter.close();
                return stringWriter.toString();
            }
            throw new Exception("http请求发生错误，错误码：" + responseCode);
        }

        static HttpURLConnection getDownloadFileConn(String address, long offset, long endIndex, SSLSocketFactory socketFactory) throws Exception {
            URL url = new URL(address);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection) conn).setSSLSocketFactory(socketFactory == null ? DefaultSSLSocketFactory.getSocketFactory() : socketFactory);
                ((HttpsURLConnection) conn).setHostnameVerifier(ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            conn.setDoInput(true);
            conn.setConnectTimeout(HTTP_TIME_OUT);
            conn.setReadTimeout(HTTP_TIME_OUT);
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Range", "bytes=" + offset + "-" + endIndex);
            return conn;
        }
    }

    /**
     * <P>description :  加密解密相关的工具类 </P>
     * <P>className : AppUtils </P>
     * <P>package : com.xdja.update.utils </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 20:00 </P>
     *
     * @author fjd
     */
    static class EncryptUtils {

        private EncryptUtils() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        /**
         * MD5加密文件
         *
         * @param file 文件
         * @return 文件的16进制密文 string
         */
        static String encryptMD5File2String(File file) {
            return bytes2HexString(encryptMD5File(file));
        }

        /**
         * MD5加密文件
         *
         * @param file 文件
         * @return 文件的MD5校验码 byte [ ]
         */
        private static byte[] encryptMD5File(File file) {
            if (file == null) {
                return null;
            }
            FileInputStream fis = null;
            DigestInputStream digestInputStream;
            try {
                fis = new FileInputStream(file);
                MessageDigest md = MessageDigest.getInstance("MD5");
                digestInputStream = new DigestInputStream(fis, md);
                byte[] buffer = new byte[256 * 1024];
                while (digestInputStream.read(buffer) > 0) {
                }
                md = digestInputStream.getMessageDigest();
                return md.digest();
            } catch (NoSuchAlgorithmException | IOException e) {
                e.printStackTrace();
                return null;
            } finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * <P>description :  转换相关工具类 </P>
     * <P>className : AppUtils </P>
     * <P>package : com.xdja.update.utils </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 20:00 </P>
     *
     * @author fjd
     */
    static class ConvertUtils {

        private ConvertUtils() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        static final char hexDigits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        /**
         * byteArr转hexString
         * <p>例如：</p>
         * bytes2HexString(new byte[] { 0, (byte) 0xa8 }) returns 00A8
         *
         * @param bytes 字节数组
         * @return 16进制大写字符串 string
         */
        static String bytes2HexString(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            int len = bytes.length;
            if (len <= 0) {
                return null;
            }
            char[] ret = new char[len << 1];
            for (int i = 0, j = 0; i < len; i++) {
                ret[j++] = hexDigits[bytes[i] >>> 4 & 0x0f];
                ret[j++] = hexDigits[bytes[i] & 0x0f];
            }
            return new String(ret);
        }

    }

    /**
     * <P>description :  App相关工具类 </P>
     * <P>className : AppUtils </P>
     * <P>package : com.xdja.update.utils </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 20:00 </P>
     *
     * @author fjd
     */
    static class AppUtils {

        private AppUtils() {
            throw new UnsupportedOperationException("u can't instantiate me...");
        }

        /**
         * 获取App包名
         *
         * @param context 上下文
         * @return App包名
         */
        static String getAppPackageName(Context context) {
            return context.getPackageName();
        }

        /**
         * 获取App名称
         *
         * @param context 上下文
         * @return App名称
         */
        static String getAppName(Context context) {
            return getAppName(context, context.getPackageName());
        }

        /**
         * 获取App名称
         *
         * @param context     上下文
         * @param packageName 包名
         * @return App名称
         */
        static String getAppName(Context context, String packageName) {
            if (packageName == null || packageName.trim().length() == 0) {
                return null;
            }
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo pi = pm.getPackageInfo(packageName, 0);
                return pi == null ? null : pi.applicationInfo.loadLabel(pm).toString();
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        /**
         * 获取App版本号
         *
         * @param context 上下文
         * @return App版本号
         */
        static String getAppVersionName(Context context) {
            return getAppVersionName(context, context.getPackageName());
        }

        /**
         * 获取App版本号
         *
         * @param context     上下文
         * @param packageName 包名
         * @return App版本号
         */
        private static String getAppVersionName(Context context, String packageName) {
            if (packageName == null || packageName.trim().length() == 0) {
                return null;
            }
            try {
                PackageManager pm = context.getPackageManager();
                PackageInfo pi = pm.getPackageInfo(packageName, 0);
                return pi == null ? null : pi.versionName;
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new HostnameVerifier() {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static class DefaultSSLSocketFactory {

        private static SSLContext sslContext;

        private static DefaultSSLSocketFactory instance;

        public static SSLSocketFactory getSocketFactory() throws Exception {
            if (instance == null) {
                instance = new DefaultSSLSocketFactory();
            }
            return sslContext.getSocketFactory();
        }

        private DefaultSSLSocketFactory()
                throws NoSuchAlgorithmException, KeyManagementException {

            TrustManager trustAllCerts = new X509TrustManager() {
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(
                        java.security.cert.X509Certificate[] chain, String authType)
                        throws java.security.cert.CertificateException {
                }

                @Override
                public void checkServerTrusted(
                        java.security.cert.X509Certificate[] chain, String authType)
                        throws java.security.cert.CertificateException {
                }
            };
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustAllCerts}, null);
        }

    }

    public static class MySSLSocketFactory {
        private static MySSLSocketFactory instance;
        private static SSLSocketFactory socketFactory;
        private String certName, pass;

        public static SSLSocketFactory getSocketFactory(Context context, String certName, String pass) {
            if (TextUtils.isEmpty(certName) || TextUtils.isEmpty(pass)) {
                return null;
            }
            if (instance == null
                    || !TextUtils.equals(instance.certName, certName)
                    || !TextUtils.equals(instance.pass, pass)) {
                instance = new MySSLSocketFactory(context, certName, pass);
            }
            return socketFactory;
        }

        private MySSLSocketFactory(Context context, String certName, String pass) {
            this.certName = certName;
            this.pass = pass;
            //获取证书
            InputStream stream = null;
            try {
                stream = context.getAssets().open(certName);
                SSLContext tls = SSLContext.getInstance("TLS");
                //使用默认证书
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                //去掉系统默认证书
                keystore.load(stream, pass.toCharArray());
                //通过信任管理器获取一个默认的算法
                String algorithm = TrustManagerFactory.getDefaultAlgorithm();
                //算法工厂创建
                TrustManagerFactory instance = TrustManagerFactory.getInstance(algorithm);
                instance.init(keystore);

                tls.init(null, instance.getTrustManagers(), null);
                socketFactory = tls.getSocketFactory();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (CertificateException e) {
                e.printStackTrace();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyStoreException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            } finally {
                if (stream != null) {
                    try {
                        stream.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}
