package com.xdja.update.bean;

import android.support.annotation.StringDef;

import java.util.List;

/**
 * <P>description : 升级检测协议类 </P>
 * <P>className : CheckProtocol </P>
 * <P>package : com.xdja.update.bean </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 8:53 </P>
 *
 * @author fjd
 */
public class CheckProtocol {

    /**
     * 老版本协议
     */
    private static final String PACT_VERSION_TRADITIONAL = "PACT_VERSION_TRADITIONAL";
    /**
     * 4.1版本协议
     */
    private static final String PACT_VERSION_4_1 = "4.1";
    /**
     * 4.2版本协议
     */
    private static final String PACT_VERSION_4_2 = "4.2";

    private static final String DOCUMENT_PREFIX = "  ";

    private static final String REQ_DEFAULT = "checkver";

    /**
     * 版本协议定义
     */
    @StringDef({PACT_VERSION_TRADITIONAL, PACT_VERSION_4_1, PACT_VERSION_4_2})
    private @interface PactVersion {
    }

    /**
     * 使用的版本协议，默认为{@link #PACT_VERSION_4_1}，注：老协议{@link #PACT_VERSION_TRADITIONAL}不发送该节点
     */
    @PactVersion
    private String pactVersion = PACT_VERSION_4_1;
    /**
     * 请求类别，默认为{@link #REQ_DEFAULT}
     */
    private String req = REQ_DEFAULT;
    /**
     * 升级服务器Ip地址。注：该节点为发送检测请求地址，不作为检测协议的内容
     */
    private String serverIp;
    /**
     * 升级服务端口号。注：该节点为发送检测请求端口，不作为检测协议的内容
     */
    private String serverPort;
    /**
     * 手机厂商
     */
    private String factory;
    /**
     * 手机型号
     */
    private String mod;
    /**
     * 系统平台
     */
    private String os;
    /**
     * 升级软件名称
     */
    private String soft;
    /**
     * 当前用户
     */
    private String userName;

    /**
     * 客户端唯一标识
     */
    private String cardNo;
    /**
     * 用户权限。注:4.2版本{@link #PACT_VERSION_4_2}需要填充该节点，其他版本无需填充。
     */
    private String power;
    /**
     * 版本号。注：该节点只有老协议{@link #PACT_VERSION_TRADITIONAL}需要发送，其他版本协议无需填充该节点
     */
    private String version;
    /**
     * 客户端版本信息队列（可能包含主框架和插件等多个组件的版本信息）
     */
    private List<Ver> vers;

    /**
     * @return 客户端唯一标识
     */
    public String getCardNo() {
        return cardNo;
    }

    /**
     * @param cardNo 客户端唯一标识
     */
    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    /**
     * @return 使用的版本协议，默认为{@link #PACT_VERSION_4_1}，注：老协议{@link #PACT_VERSION_TRADITIONAL}不发送该节点
     */
    @PactVersion
    public String getPactVersion() {
        return pactVersion;
    }

    /**
     * @param pactVersion 使用的版本协议，默认为{@link #PACT_VERSION_4_1}，注：老协议{@link #PACT_VERSION_TRADITIONAL}不发送该节点
     */
    public void setPactVersion(@PactVersion String pactVersion) {
        this.pactVersion = pactVersion;
    }

    /**
     * @return 升级服务器Ip地址。注：该节点为发送检测请求地址，不作为检测协议的内容
     */
    public String getServerIp() {
        return serverIp;
    }

    /**
     * @param serverIp 升级服务器Ip地址。注：该节点为发送检测请求地址，不作为检测协议的内容
     */
    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    /**
     * @return 升级服务端口号。注：该节点为发送检测请求端口，不作为检测协议的内容
     */
    public String getServerPort() {
        return serverPort;
    }

    /**
     * @param serverPort 升级服务端口号。注：该节点为发送检测请求端口，不作为检测协议的内容
     */
    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    /**
     * @return 请求类别，默认为{@link #REQ_DEFAULT}
     */
    public String getReq() {
        return req;
    }

    /**
     * @param req 请求类别，默认为{@link #REQ_DEFAULT}
     */
    public void setReq(String req) {
        this.req = req;
    }

    /**
     * @return 手机厂商
     */
    public String getFactory() {
        return factory;
    }

    /**
     * @param factory 手机厂商
     */
    public void setFactory(String factory) {
        this.factory = factory;
    }

    /**
     * @return 手机型号
     */
    public String getMod() {
        return mod;
    }

    /**
     * @param mod 手机型号
     */
    public void setMod(String mod) {
        this.mod = mod;
    }

    /**
     * @return 系统平台
     */
    public String getOs() {
        return os;
    }

    /**
     * @param os 系统平台
     */
    public void setOs(String os) {
        this.os = os;
    }

    /**
     * @return 升级软件名称
     */
    public String getSoft() {
        return soft;
    }

    /**
     * @param soft 升级软件名称
     */
    public void setSoft(String soft) {
        this.soft = soft;
    }

    /**
     * @return 当前用户
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName 当前用户
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * @return 用户权限。注:4.2版本{@link #PACT_VERSION_4_2}需要填充该节点，其他版本无需填充。
     */
    public String getPower() {
        return power;
    }

    /**
     * @param power 用户权限。注:4.2版本{@link #PACT_VERSION_4_2}需要填充该节点，其他版本无需填充。
     */
    public void setPower(String power) {
        this.power = power;
    }

    /**
     * @return 版本号。注：该节点只有老协议{@link #PACT_VERSION_TRADITIONAL}需要发送，其他版本协议无需填充该节点
     */
    public String getVersion() {
        return version;
    }

    /**
     * @param version 版本号。注：该节点只有老协议{@link #PACT_VERSION_TRADITIONAL}需要发送，其他版本协议无需填充该节点
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * @return 客户端版本信息队列
     */
    public List<Ver> getVers() {
        return vers;
    }

    /**
     * @param vers 客户端版本信息队列
     */
    public void setVers(List<Ver> vers) {
        this.vers = vers;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DOCUMENT_PREFIX);
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")
                .append("<Root>");
        if (!pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<PactVersion>")
                    .append(StringUtils.getEmptyIfNullOrBlank(pactVersion))
                    .append("</PactVersion>");
        }
        builder.append("<Req>")
                .append(StringUtils.getEmptyIfNullOrBlank(req))
                .append("</Req>")
                .append("<Factory>")
                .append(StringUtils.getEmptyIfNullOrBlank(factory))
                .append("</Factory>")
                .append("<Mod>")
                .append(StringUtils.getEmptyIfNullOrBlank(mod))
                .append("</Mod>")
                .append("<OS>")
                .append(StringUtils.getEmptyIfNullOrBlank(os))
                .append("</OS>")
                .append("<Soft>")
                .append(StringUtils.getEmptyIfNullOrBlank(soft))
                .append("</Soft>")
                .append("<UserName>")
                .append(StringUtils.getEmptyIfNullOrBlank(userName))
                .append("</UserName>")
                .append("<CardNo>")
                .append(StringUtils.getEmptyIfNullOrBlank(cardNo))
                .append("</CardNo>");
        if (pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<Version>")
                    .append(StringUtils.getEmptyIfNullOrBlank(version))
                    .append("</Version>");
        }
        if (pactVersion.equals(PACT_VERSION_4_2)) {
            builder.append("<Power>")
                    .append(StringUtils.getEmptyIfNullOrBlank(power))
                    .append("</Power>");
        }

        if (!pactVersion.equals(PACT_VERSION_TRADITIONAL)) {
            builder.append("<Vers>");
            if (vers != null && !vers.isEmpty()) {
                for (Ver ver : vers) {
                    builder.append(StringUtils.getEmptyIfNullOrBlank(ver.toString()));
                }
            }
            builder.append("</Vers>");
        }
        builder.append("</Root>");
        return builder.toString();
    }

    /**
     * <P>description : 版本信息请求类 </P>
     * <P>className : CheckProtocol </P>
     * <P>package : com.xdja.update.bean </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 19:53 </P>
     *
     * @author fjd
     */
    public static class Ver {
        /**
         * 版本类型（包名）
         */
        private String verType;
        /**
         * 版本名称
         */
        private String verName;
        /**
         * 发布日期
         */
        private String date;

        /**
         * @return 版本类型（包名）
         */
        public String getVerType() {
            return verType;
        }

        /**
         * @param verType 版本类型（包名）
         */
        public void setVerType(String verType) {
            this.verType = verType;
        }

        /**
         * @return 版本名称
         */
        public String getVerName() {
            return verName;
        }

        /**
         * @param verName 版本名称
         */
        public void setVerName(String verName) {
            this.verName = verName;
        }

        /**
         * @return 发布日期
         */
        public String getDate() {
            return date;
        }

        /**
         * @param date 发布日期
         */
        public void setDate(String date) {
            this.date = date;
        }

        @Override
        public String toString() {
            return "<Ver>"
                    + "<VerType>"
                    + StringUtils.getEmptyIfNullOrBlank(verType)
                    + "</VerType>"
                    + "<Version>"
                    + StringUtils.getEmptyIfNullOrBlank(verName)
                    + "</Version>"
                    + "<Date>"
                    + StringUtils.getEmptyIfNullOrBlank(date)
                    + "</Date>"
                    + "</Ver>";
        }
    }
}
