package com.xdja.update.bean;

import android.support.annotation.StringDef;

import com.xdja.update.enums.CheckUpdateError;

import java.util.List;

/**
 * <P>description : 检测更新结果 </P>
 * <P>className : CheckResult </P>
 * <P>package : com.xdja.update.bean </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 9:43 </P>
 *
 * @author fjd
 */
public class CheckResult {

    private static final String UPDATE_REQ_DEFAULT = "checkver";

    /**
     * 请求类别
     */
    private String req = UPDATE_REQ_DEFAULT;
    /**
     * 检测更新结果。参考{@link #RESULT_UPDATE_ERROR}/{@link #RESULT_UPDATE_NEGATIVE}/{@link #RESULT_UPDATE_POSITIVE}
     */
    @UpdateTag
    private String result;
    /**
     * 检测结果详细描述（格式为：[插件类型|版本号|插件名#插件类型|版本号|插件名]]）
     */
    private String modPower;
    /**
     * 检测附加信息
     */
    private String msg;
    /**
     * 更新列表
     */
    private List<Update> updates;
    /**
     * 检测升级错误原因及描述
     */
    private CheckUpdateError checkUpdateError;

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder()
                .append("<Root>")
                .append("<Req>")
                .append(StringUtils.getEmptyIfNullOrBlank(req))
                .append("</Req>")
                .append("<Result>")
                .append(StringUtils.getEmptyIfNullOrBlank(result))
                .append("</Result>")
                .append("<ModPower>")
                .append(StringUtils.getEmptyIfNullOrBlank(modPower))
                .append("</ModPower>")
                .append("<Msg>")
                .append(StringUtils.getEmptyIfNullOrBlank(msg))
                .append("</Msg>")
                .append("<Updates>");
        if (updates != null && !updates.isEmpty()) {
            for (Update update : updates) {
                sb.append(StringUtils.getEmptyIfNullOrBlank(update.toString()));
            }
        }
        sb.append("</Updates>").append("</Root>");
        return sb.toString();
    }

    /**
     * @return 更新列表
     */
    public List<Update> getUpdates() {
        return updates;
    }

    /**
     * @param updates 更新列表
     */
    public void setUpdates(List<Update> updates) {
        this.updates = updates;
    }

    /**
     * @return 请求类别
     */
    public String getReq() {
        return req;
    }

    /**
     * @param req 请求类别
     */
    public void setReq(String req) {
        this.req = req;
    }

    /**
     * @return 检测更新结果。参考{@link #RESULT_UPDATE_ERROR}/{@link #RESULT_UPDATE_NEGATIVE}/{@link #RESULT_UPDATE_POSITIVE}
     */
    @UpdateTag
    public String getResult() {
        return result;
    }

    /**
     * @param result 检测更新结果。参考{@link #RESULT_UPDATE_ERROR}/{@link #RESULT_UPDATE_NEGATIVE}/{@link #RESULT_UPDATE_POSITIVE}
     */
    public void setResult(@UpdateTag String result) {
        this.result = result;
    }

    /**
     * @return 检测结果详细描述（格式为：[插件类型|版本号|插件名#插件类型|版本号|插件名]]）
     */
    public String getModPower() {
        return modPower;
    }

    /**
     * @param modPowser 检测结果详细描述（格式为：[插件类型|版本号|插件名#插件类型|版本号|插件名]]）
     */
    public void setModPower(String modPowser) {
        this.modPower = modPowser;
    }

    /**
     * @return 检测附加信息
     */
    public String getMsg() {
        return msg;
    }

    /**
     * @param msg 检测附加信息
     */
    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 获取检测升级错误原因
     *
     * @return 检测升级错误信息
     */
    public CheckUpdateError getCheckUpdateError() {
        return checkUpdateError;
    }

    /**
     * set 检测升级失败原因
     *
     * @param checkUpdateError 检测升级错误信息
     */
    public void setCheckUpdateError(CheckUpdateError checkUpdateError) {
        this.checkUpdateError = checkUpdateError;
    }

    /**
     * <P>description : 升级更新类 </P>
     * <P>className : CheckResult </P>
     * <P>package : com.xdja.update.bean </P>
     * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
     * <P>date-time : 2019/9/19 19:54 </P>
     */
    public static class Update {
        /**
         * 版本类型（包名）
         */
        private String verType;
        /**
         * 版本号
         */
        private String version;
        /**
         * 发布日期
         */
        private String date;
        /**
         * 备注信息
         */
        private String comment;
        /**
         * 更新标识（0提醒升级，1强制升级）
         */
        private int updateTag;
        /**
         * 该更新相关的文件列表
         */
        private List<File> files;

        /**
         * @return 版本类型（包名）
         */
        public String getVerType() {
            return verType;
        }

        /**
         * @param verType 版本类型（包名）
         */
        public void setVerType(String verType) {
            this.verType = verType;
        }

        /**
         * @return 版本号
         */
        public String getVersion() {
            return version;
        }

        /**
         * @param version 版本号
         */
        public void setVersion(String version) {
            this.version = version;
        }

        /**
         * @return 发布日期
         */
        public String getDate() {
            return date;
        }

        /**
         * @param date 发布日期
         */
        public void setDate(String date) {
            this.date = date;
        }

        /**
         * @return 备注信息
         */
        public String getComment() {
            return comment;
        }

        /**
         * @param comment 备注信息
         */
        public void setComment(String comment) {
            this.comment = comment;
        }

        /**
         * @return 更新标识（0提醒升级，1强制升级）
         */
        public int getUpdateTag() {
            return updateTag;
        }

        /**
         * @param updateTag 更新标识（0提醒升级，1强制升级）
         */
        public void setUpdateTag(int updateTag) {
            this.updateTag = updateTag;
        }

        /**
         * @return 该更新相关的文件列表
         */
        public List<File> getFiles() {
            return files;
        }

        /**
         * @param files 该更新相关的文件列表
         */
        public void setFiles(List<File> files) {
            this.files = files;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("<Update>")
                    .append("<VerType>")
                    .append(StringUtils.getEmptyIfNullOrBlank(verType))
                    .append("</VerType>")
                    .append("<Version>")
                    .append(StringUtils.getEmptyIfNullOrBlank(version))
                    .append("</Version>")
                    .append("<Date>")
                    .append(StringUtils.getEmptyIfNullOrBlank(date))
                    .append("</Date>")
                    .append("<Comment>")
                    .append(StringUtils.getEmptyIfNullOrBlank(comment))
                    .append("</Comment>")
                    .append("<UpdateTag>")
                    .append(updateTag)
                    .append("</UpdateTag>")
                    .append("<Files>");
            if (files != null && !files.isEmpty()) {
                for (File file : files) {
                    builder.append(StringUtils.getEmptyIfNullOrBlank(file.toString()));
                }
            }
            builder.append("</Files>").append("</Update>");
            return builder.toString();
        }

        /**
         * <P>description : 升级文件类 </P>
         * <P>className : Update </P>
         * <P>package : com.xdja.update.bean </P>
         * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
         * <P>date-time : 2019/9/19 19:55 </P>
         */
        public static class File {
            /**
             * 升级文件所在路径，相对路径
             */
            private String rPath;
            /**
             * 安装路径
             */
            private String lPath;
            /**
             * 文件名
             */
            private String fName;
            /**
             * 文件总大小
             */
            private long fSize;
            /**
             * 执行动作（0 执行|1添加|2 替换|3 删除）
             */
            private int action;
            /**
             * 状态（0未处理 1正在处理 2已经处理）
             */
            private int state;
            /**
             * 已下载文件大小
             */
            private long cSize;
            /**
             * 文件校验码
             */
            private String checkCode;
            /**
             * 数据库删除标示[0 不删除数据库 1 删除数据库]
             */
            private int deleteDb;
            /**
             * 文件ID
             */
            private String fileId;

            /**
             * @return 升级文件所在路径，相对路径
             */
            public String getrPath() {
                return rPath;
            }

            /**
             * @param rPath 升级文件所在路径，相对路径
             */
            public void setrPath(String rPath) {
                this.rPath = rPath;
            }

            /**
             * @return 安装路径
             */
            public String getlPath() {
                return lPath;
            }

            /**
             * @param lPath 安装路径
             */
            public void setlPath(String lPath) {
                this.lPath = lPath;
            }

            /**
             * @return 文件名
             */
            public String getfName() {
                return fName;
            }

            /**
             * @param fName 文件名
             */
            public void setfName(String fName) {
                this.fName = fName;
            }

            /**
             * @return 文件总大小
             */
            public long getfSize() {
                return fSize;
            }

            /**
             * @param fSize 文件总大小
             */
            public void setfSize(long fSize) {
                this.fSize = fSize;
            }

            /**
             * @return 执行动作（0 执行|1添加|2 替换|3 删除）
             */
            public int getAction() {
                return action;
            }

            /**
             * @param action 执行动作（0 执行|1添加|2 替换|3 删除）
             */
            public void setAction(int action) {
                this.action = action;
            }

            /**
             * @return 状态（0未处理 1正在处理 2已经处理）
             */
            public int getState() {
                return state;
            }

            /**
             * @param state 状态（0未处理 1正在处理 2已经处理）
             */
            public void setState(int state) {
                this.state = state;
            }

            /**
             * @return 已下载文件大小
             */
            public long getcSize() {
                return cSize;
            }

            /**
             * @param cSize 已下载文件大小
             */
            public void setcSize(long cSize) {
                this.cSize = cSize;
            }

            /**
             * @return 文件校验码
             */
            public String getCheckCode() {
                return checkCode;
            }

            /**
             * @param checkCode 文件校验码
             */
            public void setCheckCode(String checkCode) {
                this.checkCode = checkCode;
            }

            /**
             * @return 数据库删除标示[0 不删除数据库 1 删除数据库]
             */
            public int getDeleteDb() {
                return deleteDb;
            }

            /**
             * @param deleteDb 数据库删除标示[0 不删除数据库 1 删除数据库]
             */
            public void setDeleteDb(int deleteDb) {
                this.deleteDb = deleteDb;
            }

            /**
             * @return 文件ID
             */
            public String getFileId() {
                return fileId;
            }

            /**
             * @param fileId 文件ID
             */
            public void setFileId(String fileId) {
                this.fileId = fileId;
            }

            @Override
            public String toString() {
                return "<File>"
                        + "<RPath>"
                        + StringUtils.getEmptyIfNullOrBlank(rPath)
                        + "/RPath"
                        + "<LPath>"
                        + StringUtils.getEmptyIfNullOrBlank(lPath)
                        + "</LPath>"
                        + "<FName>"
                        + StringUtils.getEmptyIfNullOrBlank(fName)
                        + "</FName>"
                        + "<FSize>"
                        + fSize
                        + "</FSize>"
                        + "<Action>"
                        + action
                        + "</Action>"
                        + "<State>"
                        + state
                        + "</State>"
                        + "<CSize>"
                        + cSize
                        + "</CSize>"
                        + "<CheckCode>"
                        + StringUtils.getEmptyIfNullOrBlank(checkCode)
                        + "</CheckCode>"
                        + "<DeleteDb>"
                        + deleteDb
                        + "</DeleteDb>"
                        + "<FileId>"
                        + StringUtils.getEmptyIfNullOrBlank(fileId)
                        + "</FileId>"
                        + "</File>";
            }
        }
    }

    /**
     * 升级检测结果约束注解，参考{@link #RESULT_UPDATE_ERROR}/{@link #RESULT_UPDATE_NEGATIVE}/{@link #RESULT_UPDATE_POSITIVE}
     */
    @StringDef({RESULT_UPDATE_ERROR, RESULT_UPDATE_NEGATIVE, RESULT_UPDATE_POSITIVE})
    @interface UpdateTag {
    }

    /**
     * 检测更新失败
     */
    public static final String RESULT_UPDATE_ERROR = "-1";
    /**
     * 无更新
     */
    public static final String RESULT_UPDATE_NEGATIVE = "1";
    /**
     * 有更新
     */
    public static final String RESULT_UPDATE_POSITIVE = "0";
}
