package com.xdja.update.enums;

/**
 * <P>description : 升级检测错误枚举类 </P>
 * <P>className : CheckUpdateError </P>
 * <P>package : com.xdja.update.enums </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 19:59 </P>
 * @author fjd
 */
public enum CheckUpdateError {

    /**
     * 未知错误
     */
    CHECK_UNKNOW_ERROR(0, "未知错误"),
    /**
     * 本地配置文件有错
     */
    CHECK_CONFIG_ERROR(1, "本地配置文件有错"),
    /**
     * 请求升级失败
     */
    CHECK_UPDATE_ERROR(2, "请求升级失败"),
    /**
     * 升级服务器响应数据有误
     */
    CHECK_SERVER_ERROR(3, "升级服务器响应数据有误"),
    /**
     * 解析升级数据失败
     */
    CHECK_DATA_ERROR(4, "解析升级数据失败"),
    /**
     * 请求参数有误
     */
    CHECK_REQUEST_PARAMETER_ERROR(5, "请求参数有误"),
    /**
     * 正在执行其他升级任务,请等待其他任务完成
     */
    CHECK_BUSY_ERROR(6, "正在执行其他升级任务,请等待其他任务完成");

    private int key;
    private String describe;

    /**
     * Instance A CheckUpdateError
     *
     * @param key      错误标识
     * @param describe 错误描述
     */
    CheckUpdateError(int key, String describe) {
        this.key = key;
        this.describe = describe;
    }

    /**
     * 根据错误标识获取错误枚举
     *
     * @param key 错误标识
     * @return 错误枚举
     */
    public static CheckUpdateError getCheckUpdateError(int key) {
        CheckUpdateError checkResult = CHECK_UNKNOW_ERROR;

        for (CheckUpdateError type : CheckUpdateError.values()) {
            if (type.getKey() == key) {
                checkResult = type;
                break;
            }
        }

        return checkResult;
    }

    /**
     * @return 错误标识
     */
    public int getKey() {
        return key;
    }

    /**
     * return 错误描述
     */
    public String getDescribe() {
        return describe;
    }
}
