package com.xdja.update.enums;

/**
 * <P>description : 文件下载错误枚举类 </P>
 * <P>className : DownLoadFileError </P>
 * <P>package : com.xdja.update.enums </P>
 * <P>author : <a href="mailto:fjd@xdja.com">fanjiandong</a> </P>
 * <P>date-time : 2019/9/19 19:59 </P>
 * @author fjd
 */
public enum DownLoadFileError {

    /**
     * 下载升级文件失败
     */
    DOWNLOAD_DEFAULT(0, "下载升级文件失败"),

    /**
     * fieldid为空
     */
    DOWNLOAD_NULL_FIELD_ID(1, "fieldid为空"),

    /**
     * 下载过程中网络超时
     */
    DOWNLOAD_TIME_OUT(2, "下载过程中网络超时"),

    /**
     * 服务器响应错误
     */
    DOWNLOAD_SERVER_RESPONSE_ERROR(3, "服务器响应错误"),

    /**
     * 文件校验失败
     */
    DOWNLOAD_HASHCODE_ERROR(4, "文件校验失败"),

    /**
     * 创建下载文件目录出错，下载路径不合法或未获取存储卡权限
     */
    DOWNLOAD_STORGE_PERMISSION_ERROR(5, "创建下载文件目录出错，下载路径不合法或未获取存储卡权限"),

    /**
     * 正在执行其他升级任务,请等待其他任务完成
     */
    DOWNLOAD_BUSY_ERROR(6, "正在执行其他升级任务,请等待其他任务完成");


    private int key;
    private String describe;

    /**
     * Instance A DownLoadFileError
     *
     * @param key      错误标识
     * @param describe 错误描述
     */
    DownLoadFileError(int key, String describe) {
        this.key = key;
        this.describe = describe;
    }

    /**
     * 根据错误标识获取错误枚举
     *
     * @param key 错误标识
     * @return 错误枚举
     */
    public static DownLoadFileError getDownLoadFileResult(int key) {
        DownLoadFileError downLoadFileResult = DOWNLOAD_DEFAULT;

        for (DownLoadFileError type : DownLoadFileError.values()) {
            if (type.getKey() == key) {
                downLoadFileResult = type;
                break;
            }
        }

        return downLoadFileResult;
    }

    /**
     * @return 错误标识
     */
    public int getKey() {
        return key;
    }

    /**
     * return 错误描述
     */
    public String getDescribe() {
        return describe;
    }
}
