/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.update.DelegateDownloadCallback;
import com.xdja.update.DownloadCallback;
import com.xdja.update.U;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.DownLoadFileError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.util.Arrays;
import org.json.JSONObject;

class DownloadTask
extends AsyncTask<String, Long, Boolean> {
    private final String TAG = DownloadTask.class.getSimpleName();
    private final int BUFFER_UNIT = 524288;
    private final String DOWNLOAD_PROJECT_NAME = "/Update/api/upgrade/downloadApk.do?fileId=";
    private final CheckResult.Update.File file;
    private final DownloadCallback callback;
    private final String baseUrl;
    private volatile boolean isStop = false;
    private Context context;
    private String certName;
    private String pass;

    DownloadTask(@NonNull CheckResult.Update.File file, @NonNull DownloadCallback callback, @NonNull String baseUrl, Context context, String certName, String pass) {
        this.context = context;
        this.file = file;
        this.callback = new DelegateDownloadCallback(callback);
        this.baseUrl = baseUrl;
        this.certName = certName;
        this.pass = pass;
    }

    synchronized void stop() {
        this.isStop = true;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.callback.onStart(this.file.getFileId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean doInBackground(String ... params) {
        final String fileId = this.file.getFileId();
        RandomAccessFile randomAccessFile = null;
        if (this.checkFileId(this.file.getFileId())) {
            return false;
        }
        try {
            if (this.checkDir(fileId)) {
                Boolean bl = false;
                return bl;
            }
            File targetFile = new File(this.callback.downloadDir() + "/" + fileId + ".apk");
            if (this.checkFile(fileId, targetFile)) {
                Boolean e = false;
                return e;
            }
            long offset = targetFile.length();
            Boolean result = this.seekFile(fileId, offset, randomAccessFile = new RandomAccessFile(targetFile, "rws"), targetFile);
            if (result != null) {
                Boolean bl = result;
                return bl;
            }
            long endIndex = this.getEndIndex(offset);
            String fileUrl = this.getFileUrl(this.baseUrl, fileId);
            while (!this.isStop) {
                HttpURLConnection conn = U.HttpUtils.getDownloadFileConn(fileUrl, offset, endIndex, U.MySSLSocketFactory.getSocketFactory(this.context, this.certName, this.pass));
                int responseCode = conn.getResponseCode();
                if (responseCode == 200 || responseCode == 206) {
                    InputStream is = conn.getInputStream();
                    if (is != null) {
                        this.appendStream(randomAccessFile, is);
                        is.close();
                        offset = endIndex + 1L;
                        result = this.seekFile(fileId, offset, randomAccessFile, targetFile);
                        if (result != null) {
                            Boolean bl = result;
                            return bl;
                        }
                    } else {
                        Log.d((String)this.TAG, (String)"====\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519====");
                        this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_DEFAULT, null);
                        Boolean bl = false;
                        return bl;
                    }
                    endIndex = this.getEndIndex(offset);
                    continue;
                }
                Log.d((String)this.TAG, (String)("====\u670d\u52a1\u5668\u54cd\u5e94\u9519\u8bef\uff0c\u54cd\u5e94\u7801\uff1a" + responseCode + "===="));
                this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_SERVER_RESPONSE_ERROR, null);
                Boolean bl = false;
                return bl;
            }
            U.HandlerUtils.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    DownloadTask.this.callback.onStop(fileId);
                }
            });
            Boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Log.d((String)this.TAG, (String)("====\r\n\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519 : " + e.getMessage() + "\r\n===="));
            Log.d((String)this.TAG, (String)("downloadFileError: " + Arrays.toString(e.getStackTrace())));
            this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_DEFAULT, e);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException e) {
                this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_DEFAULT, e);
            }
        }
    }

    protected void onProgressUpdate(Long ... values) {
        super.onProgressUpdate((Object[])values);
        this.callback.onProgress(this.file.getFileId(), this.file.getfSize(), values[0]);
    }

    protected void onPostExecute(Boolean result) {
        super.onPostExecute((Object)result);
        if (result.booleanValue()) {
            this.callback.onComplete(this.file.getFileId(), this.callback.downloadDir() + "/" + this.file.getFileId() + ".apk");
        }
    }

    private void appendStream(RandomAccessFile randomAccessFile, InputStream is) throws IOException {
        int count;
        byte[] buffer = new byte[524288];
        while ((count = is.read(buffer, 0, 524288)) != -1) {
            randomAccessFile.write(buffer, 0, count);
        }
    }

    private String getFileUrl(String baseUrl, String fileId) throws Exception {
        String fileUrlResult = U.HttpUtils.postString(baseUrl + "/Update/api/upgrade/downloadApk.do?fileId=" + fileId, null, U.MySSLSocketFactory.getSocketFactory(this.context, this.certName, this.pass));
        JSONObject jsonObject = new JSONObject(fileUrlResult);
        int code = jsonObject.getInt("code");
        String message = jsonObject.getString("message");
        String data = jsonObject.getString("data");
        if (code == 0) {
            throw new Exception(message);
        }
        return data;
    }

    private long getEndIndex(long offset) {
        long l = this.file.getfSize() - offset;
        long endIndex = l >= (long)this.callback.unit() ? offset + (long)this.callback.unit() - 1L : this.file.getfSize() - 1L;
        return endIndex;
    }

    private boolean verifyFile(File file, String except) {
        String actual = U.EncryptUtils.encryptMD5File2String(file).toLowerCase();
        return actual.equals(except.toLowerCase());
    }

    private Boolean seekFile(String fileId, long offset, RandomAccessFile randomAccessFile, File targetFile) throws IOException {
        if (offset >= this.file.getfSize()) {
            Log.d((String)this.TAG, (String)"====\u6587\u4ef6\u5df2\u4e0b\u8f7d\u5b8c\u6210====");
            if (this.verifyFile(targetFile, this.file.getCheckCode())) {
                return true;
            }
            if (!targetFile.delete()) {
                this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_STORGE_PERMISSION_ERROR, null);
                return false;
            }
            this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_HASHCODE_ERROR, null);
            return false;
        }
        this.publishProgress(new Long[]{offset});
        randomAccessFile.seek(offset);
        return null;
    }

    private boolean checkDir(String fileId) {
        boolean mkdirs;
        File targetDir = new File(this.callback.downloadDir());
        if (!targetDir.exists() && !(mkdirs = targetDir.mkdirs())) {
            Log.d((String)this.TAG, (String)"====\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u5939\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84\u662f\u5426\u5408\u6cd5====");
            this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_STORGE_PERMISSION_ERROR, null);
            return true;
        }
        return false;
    }

    private boolean checkFileId(String fileId) {
        if (TextUtils.isEmpty((CharSequence)fileId)) {
            Log.d((String)this.TAG, (String)"====fileId\u4e3a\u7a7a====");
            this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_NULL_FIELD_ID, null);
            return true;
        }
        return false;
    }

    private boolean checkFile(String fileId, File targetFile) throws IOException {
        if (!targetFile.exists() && !targetFile.createNewFile()) {
            Log.d((String)this.TAG, (String)"====\u6587\u4ef6\u521b\u5efa\u5931\u8d25====");
            this.callback.onError(fileId, DownLoadFileError.DOWNLOAD_DEFAULT, null);
            return true;
        }
        return false;
    }
}

