/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.update;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.xdja.update.CheckCallback;
import com.xdja.update.CheckTask;
import com.xdja.update.DownloadCallback;
import com.xdja.update.DownloadTask;
import com.xdja.update.bean.CheckProtocol;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.CheckUpdateError;
import com.xdja.update.enums.DownLoadFileError;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UpdateManager {
    private static final String TAG = UpdateManager.class.getSimpleName();
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAXIMUM_POOL_SIZE = 5;
    private static final long KEEP_ALIVE_TIME = 10000L;
    private static final int QUEUE_CAPACITY = 2;
    private static final String THREAD_GROUP_NAME = "UpdateThreadGroup";
    private static final String THREAD_NAME = "UpdateThread";
    private static final String CLIENT_VERSION_FILE = "ClientVer.xml";
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile UpdateManager INSTANCE;
    private AccessConfig accessConfig = new AccessConfig();
    private Executor exec;
    private Context context;
    private AsyncTask checkTask;
    private DownloadTask downloadTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<UpdateManager> clazz = UpdateManager.class;
        synchronized (UpdateManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new UpdateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private UpdateManager() {
    }

    public void install(@NonNull Context context) {
        this.context = context.getApplicationContext();
        this.exec = new ThreadPoolExecutor(2, 5, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2), new ThreadFactory(){
            int count = 0;

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(new ThreadGroup(UpdateManager.THREAD_GROUP_NAME), r, UpdateManager.THREAD_NAME + this.count++);
            }
        });
    }

    public void install(@NonNull Context context, @Nullable String ip, @Nullable String port, @Nullable String cardNo, boolean isAppSelfish, boolean isSubstitute) {
        this.install(context, null, ip, port, cardNo, isAppSelfish, isSubstitute);
    }

    public void install(@NonNull Context context, @Nullable HTTP_SCHEME scheme, @Nullable String ip, @Nullable String port, @Nullable String cardNo, boolean isAppSelfish, boolean isSubstitute) {
        this.install(context, scheme, ip, port, cardNo, isAppSelfish, isSubstitute, null, null);
    }

    public void install(@NonNull Context context, @Nullable HTTP_SCHEME scheme, @Nullable String ip, @Nullable String port, @Nullable String cardNo, boolean isAppSelfish, boolean isSubstitute, @Nullable String certName, @Nullable String pass) {
        this.install(context);
        if (scheme != null) {
            this.accessConfig.setSchemeStr(scheme.value);
        }
        this.accessConfig.setIp(ip);
        this.accessConfig.setPort(port);
        this.accessConfig.setCardNo(cardNo);
        this.accessConfig.setAppSelfish(isAppSelfish);
        this.accessConfig.setSubstitute(isSubstitute);
        this.accessConfig.setCertName(certName);
        this.accessConfig.setPass(pass);
    }

    public void uninstall() {
        this.context = null;
        this.exec = null;
        this.checkTask = null;
        this.downloadTask = null;
        this.accessConfig = null;
    }

    public void checkUpdate(@NonNull CheckCallback checkCallback) {
        if (this.isBusy()) {
            checkCallback.onCheckResult(this.buildBusyError());
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u4efb\u52a1\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u5373\u5c06\u5f00\u59cb=======");
        this.checkTask = new CheckTask(this.context, checkCallback, this.accessConfig).executeOnExecutor(this.exec, new String[]{CLIENT_VERSION_FILE});
    }

    public void checkUpdate(@NonNull CheckCallback checkCallback, @NonNull CheckProtocol checkProtocol) {
        if (this.isBusy()) {
            checkCallback.onCheckResult(this.buildBusyError());
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u4efb\u52a1\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u68c0\u6d4b\u5373\u5c06\u5f00\u59cb=======");
        this.checkTask = new CheckTask(this.context, checkCallback, this.accessConfig).executeOnExecutor(this.exec, new CheckProtocol[]{checkProtocol});
    }

    public void cancelCheckUpdate() {
        if (this.checkTask != null) {
            this.checkTask.cancel(true);
        }
    }

    public void downloadFile(@NonNull CheckResult.Update.File file, @NonNull DownloadCallback callback) {
        if (this.isBusy()) {
            callback.onError(file.getFileId(), DownLoadFileError.DOWNLOAD_BUSY_ERROR, null);
            Log.d((String)TAG, (String)"======\u6709\u672a\u6267\u884c\u5b8c\u6210\u7684\u4efb\u52a1,\u672c\u6b21\u4e0b\u8f7d\u53d6\u6d88=======");
            return;
        }
        Log.d((String)TAG, (String)"======\u65e0\u5f85\u6267\u884c\u7684\u4efb\u52a1,\u672c\u6b21\u4e0b\u8f7d\u5373\u5c06\u5f00\u59cb=======");
        this.downloadTask = new DownloadTask(file, callback, this.accessConfig.getBaseUrl(), this.context, this.accessConfig.getCertName(), this.accessConfig.getPass());
        this.downloadTask.executeOnExecutor(this.exec, new String[0]);
    }

    public void stopDownload() {
        if (this.downloadTask != null && this.downloadTask.getStatus() != AsyncTask.Status.FINISHED) {
            this.downloadTask.stop();
        }
    }

    private CheckResult buildBusyError() {
        CheckResult checkResult = new CheckResult();
        checkResult.setResult("-1");
        checkResult.setCheckUpdateError(CheckUpdateError.CHECK_BUSY_ERROR);
        return checkResult;
    }

    private boolean isBusy() {
        return this.checkTask != null && this.checkTask.getStatus() != AsyncTask.Status.FINISHED || this.downloadTask != null && this.downloadTask.getStatus() != AsyncTask.Status.FINISHED;
    }

    static final class AccessConfig {
        private String certName;
        private String schemeStr = HTTP_SCHEME.access$000(HTTP_SCHEME.HTTP);
        private String ip;
        private String port;
        private String cardNo;
        private boolean isAppSelfish = false;
        private boolean isSubstitute = false;
        private String baseUrl;
        private String pass;

        AccessConfig() {
        }

        String getBaseUrl() {
            return this.baseUrl;
        }

        void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        String getIp() {
            return this.ip;
        }

        private void setIp(String ip) {
            this.ip = ip;
        }

        String getPort() {
            return this.port;
        }

        private void setPort(String port) {
            this.port = port;
        }

        String getCardNo() {
            return this.cardNo;
        }

        private void setCardNo(String cardNo) {
            this.cardNo = cardNo;
        }

        boolean isSubstitute() {
            return this.isSubstitute;
        }

        private void setSubstitute(boolean substitute) {
            this.isSubstitute = substitute;
        }

        public boolean isAppSelfish() {
            return this.isAppSelfish;
        }

        public void setAppSelfish(boolean isAppSelfish) {
            this.isAppSelfish = isAppSelfish;
        }

        String getSchemeStr() {
            return this.schemeStr;
        }

        void setSchemeStr(String schemeStr) {
            this.schemeStr = schemeStr;
        }

        String getCertName() {
            return this.certName;
        }

        void setCertName(String certName) {
            this.certName = certName;
        }

        String getPass() {
            return this.pass;
        }

        void setPass(String pass) {
            this.pass = pass;
        }
    }

    public static enum HTTP_SCHEME {
        HTTP("http"),
        HTTPS("https");

        private String value;

        private HTTP_SCHEME(String value) {
            this.value = value;
        }
    }
}

