package com.xdja.upgrade.bean;

import android.content.SharedPreferences;

import com.thoughtworks.xstream.annotations.XStreamAlias;

import java.util.Map;

/**
 * 描述升级功能对应的配置
 * <p/>
 * <ol>
 * <li>升级服务器ip地址</li>
 * <li>升级服务器端口</li>
 * <li>设置超时时间(最大不得超过20000ms)</li>
 * </ol>
 */
@XStreamAlias("Root")
public class ClientVersion {

    @XStreamAlias("ServerIP")
    private String ip;

    @XStreamAlias("ServerPort")
    private String port;
    //默认配置超时时间5000ms
    private int timeOut = 5000;

    @XStreamAlias("Factory")
    private String factory;

    @XStreamAlias("Mod")
    private String mode;

    @XStreamAlias("OS")
    private String os;

    @XStreamAlias("Soft")
    private String soft;

    @XStreamAlias("UserName")
    private String userName;

    @XStreamAlias("Ver")
    Version ver;

    /**
     * 读取shared 默认配置
     *
     * @param sharedPreferences
     * @return
     */
    public ClientVersion readConfig(SharedPreferences sharedPreferences) {
        Map<String, ?> sharedMap = sharedPreferences.getAll();
        setIp(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_IP_KEY)));
        setPort(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_PORT_KEY)));
        setFactory(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_FACTORY_KEY)));
        setMode(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_MOD_KEY)));
        setOs(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_OS_KEY)));
        setSoft(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_SOFT_KEY)));
        setUserName(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_USERNAME_KEY)));
//        setVersion(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_VERSION_KEY)));
//        setDate(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_DATE_KEY)));
//        setNote(String.valueOf(sharedMap.get(ClientVersionXmlTag.TAG_SERVER_NOTE_KEY)));
        return this;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public int getTimeOut() {
        return timeOut;
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getSoft() {
        return soft;
    }

    public void setSoft(String soft) {
        this.soft = soft;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Version getVer() {
        return ver;
    }

    public void setVer(Version ver) {
        this.ver = ver;
    }

    @Override
    public String toString() {
        return "ClientVersion{" +
                "ip='" + ip + '\'' +
                ", port='" + port + '\'' +
                ", timeOut=" + timeOut +
                ", factory='" + factory + '\'' +
                ", mode='" + mode + '\'' +
                ", os='" + os + '\'' +
                ", soft='" + soft + '\'' +
                ", userName='" + userName + '\'' +
                ", ver=" + ver.toString() +
                '}';
    }
}
