package com.xdja.upgrade.bean;

import android.util.Log;

import com.xdja.upgrade.util.AppUtil;

/**
 * Description:拼装请求协议
 * Created by zjc on 2017/5/18 0018.
 */
public class Protocol {

    private static final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    private static final String ROOT_LEFT = "<Root>";

    private static final String REQ = "<Req>checkver</Req>";

    private static final String FACTORY_LEFT = "<Factory>";

    private static final String FACTORY_RIGHT = "</Factory>";

    private static final String MODE_LEFT = "<Mod>";

    private static final String MODE_RIGHT = "</Mod>";

    private static final String OS_LEFT = "<OS>";

    private static final String OS_RIGHT = "</OS>";

    private static final String SOFT_LEFT = "<Soft>";

    private static final String SOFT_RIGHT = "</Soft>";

    private static final String VERSION_LEFT = "<Version>";

    private static final String VERSION_RIGHT = "</Version>";

    private static final String USER_NAME_LEFT = "<UserName>";

    private static final String USER_NAME_RIGHT = "</UserName>";

    private static final String ROOT_RIGHT = "</Root>";

    /**
     * 根据xml转换出的bean对象，构造协议请求报文
     * @param version
     * @return
     */
    public static String build(ClientVersion version) {

        //这个地方要不要加校验

        StringBuilder head = new StringBuilder();
        head.append(XML_TAG);

        head.append(ROOT_LEFT);

        head.append(REQ);

        head.append(FACTORY_LEFT);
        head.append(version.getFactory());
        head.append(FACTORY_RIGHT);

        head.append(MODE_LEFT);
        head.append(version.getMode());
        head.append(MODE_RIGHT);

        head.append(OS_LEFT);
        head.append(version.getOs());
        head.append(OS_RIGHT);

        head.append(SOFT_LEFT);
        head.append(version.getSoft());
        head.append(SOFT_RIGHT);

        head.append(VERSION_LEFT);
        head.append(version.getVer().getVersion());
        head.append(VERSION_RIGHT);

        head.append(USER_NAME_LEFT);
        head.append(version.getUserName());
        head.append(USER_NAME_RIGHT);

        head.append(ROOT_RIGHT);

        String result = head.toString();
        Log.d(AppUtil.TAG, result);
        return result;

    }

}
