package com.xdja.upgrade.bean;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.xdja.upgrade.bean.update_s_bean.Update;

/**
 * 根据服务器返回的数据内容，转换为当前对象
 * Created by wanghao on 2016/11/24.
 * 通讯系统名词RXD 为接收数据的引脚
 */
@XStreamAlias("Root")
public class RXDConfig {

    @XStreamAlias("Update")
    Update update;

    public Update getUpdate() {
        return update;
    }

    public void setUpdate(Update update) {
        this.update = update;
    }

    //这些值是原先xml文件中子标签的值，现在通过get的方式提供一下

  /*  public String getVersion() {
        return update.getVersion();
    }

    public String getDate() {
        return update.getDate();
    }

    public String getComment() {
        return update.getComment();
    }

    public String getUpdateTag() {
        return update.getUpdateTag();
    }*/

    /**
     * 0是普通升级
     * 1是强制升级
     * @return
     */
    public boolean isForceUpdate() {
        return !"0".equals(update.getUpdateTag()) ? true : false;
    }

    @Override
    public String toString() {
        return "RxdConfig{" +
                "update=" + update +
                '}';
    }

}


