package com.xdja.upgrade.bean;

import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.update_s_bean.File;

/**
 * Created by wanghao on 2016/11/23.
 * 更新功能的请求头
 */
public class RequestHead {

    public static final String TAG = RequestHead.class.getName();

    /**
     * 发送请求头给服务器，检测版本
     *
     * @param clientVersion
     * @return
     */
    public static String buildRequest(ClientVersion clientVersion) {
        UpdateLog.d(TAG, "组装请求头");

        StringBuilder version = new StringBuilder();
        version.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        version.append("<Root>");

        version.append("<Req>checkver</Req>");

        version.append("<Factory>");
        version.append(clientVersion.getFactory());
        version.append("</Factory>");

        version.append("<Mod>");
        version.append(clientVersion.getMode());
        version.append("</Mod>");

        version.append("<OS>");
        version.append(clientVersion.getOs());
        version.append("</OS>");

        version.append("<Soft>");
        version.append(clientVersion.getSoft());
        version.append("</Soft>");

        version.append("<Version>");
        version.append(clientVersion.getVer().getVersion());
        version.append("</Version>");

        version.append("<UserName>");
        version.append(clientVersion.getUserName());
        version.append("</UserName>");

        version.append("</Root>");

        String result = version.toString();
        UpdateLog.d(TAG, "组装结果" + "\n" + result);
        return result;
    }

    /**
     * 发送断点续传文件头
     *
     * @return
     */
    public static String buildBreakPointTransmition(File file) {
        StringBuilder brokenTransfer = new StringBuilder();
        brokenTransfer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        brokenTransfer.append("<Root>");

        brokenTransfer.append("<Req>getfile</Req>");

        brokenTransfer.append("<RPath>");
        brokenTransfer.append(file.getRemotePath());
        brokenTransfer.append("</RPath>");

        brokenTransfer.append("<LPath>");
        brokenTransfer.append(file.getLocalPath());
        brokenTransfer.append("</LPath>");

        brokenTransfer.append("<FName>");
        brokenTransfer.append(file.getFileName());
        brokenTransfer.append("</FName>");

        brokenTransfer.append("<FSize>");
        brokenTransfer.append(file.getFileSize());
        brokenTransfer.append("</FSize>");

        brokenTransfer.append("<FPos>");
        brokenTransfer.append(file.getDownloadSize());
        brokenTransfer.append("</FPos>");

        brokenTransfer.append("</Root>");
        return brokenTransfer.toString();
    }

}
