package com.xdja.upgrade.bean.update_s_bean;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * Description:
 * Created by zjc on 2017/6/6 0006.
 */
@XStreamAlias("File")
public class File {

    @XStreamAlias("RPath")
    private String remotePath;  // 远程文件所在路径

    @XStreamAlias("LPath")
    private String localPath;   // 本地文件所在路径

    @XStreamAlias("FName")
    private String fileName; // 文件名

    @XStreamAlias("FSize")
    private long fileSize; // 文件大小

    @XStreamAlias("Action")
    private String action; // 动作类型
    /**
     * 0 : 还未执行任何动作; 1 正在下载 ;2  下载完成
     * <p/>
     *
     * @see com.xdja.upgrade.util.UpdateConfigConst.DownloadState#UNDOWNLOAD
     * @see com.xdja.upgrade.util.UpdateConfigConst.DownloadState#DOWNLOADING
     * @see com.xdja.upgrade.util.UpdateConfigConst.DownloadState#DOWNLOADED
     * </p>
     */
    @XStreamAlias("State")
    private String state; // 当前状态

    @XStreamAlias("CSize")
    private long downloadSize; // 当前已经下载大小

    @XStreamAlias("CheckCode")
    private String checkCode; // 校验码

    @XStreamAlias("DeleteDb")
    private String deleteDb; // 删除数据库

    @XStreamAlias("FileId")
    private String fileId;

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getRemotePath() {
        return remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public String getLocalPath() {
        return localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public long getDownloadSize() {
        return downloadSize;
    }

    public void setDownloadSize(long downloadSize) {
        this.downloadSize = downloadSize;
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    public String getDeleteDb() {
        return deleteDb;
    }

    public void setDeleteDb(String deleteDb) {
        this.deleteDb = deleteDb;
    }

    @Override
    public String toString() {
        return "File{" +
                "remotePath='" + remotePath + '\'' +
                ", localPath='" + localPath + '\'' +
                ", fileName='" + fileName + '\'' +
                ", fileSize=" + fileSize +
                ", action='" + action + '\'' +
                ", state='" + state + '\'' +
                ", downloadSize=" + downloadSize +
                ", checkCode='" + checkCode + '\'' +
                ", deleteDb='" + deleteDb + '\'' +
                ", fileId='" + fileId + '\'' +
                '}';
    }
}