package com.xdja.upgrade.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.ui.AlertDialogWrapper;

/**
 * Description:
 * Created by Administrator on 2017/6/13 0013.
 */
public class UpdateReceiver extends BroadcastReceiver {

    /**
     * 应用启动广播，需手动替换成自己的模块
     */
    public static final String ACTION_APP_START = "com.xdja.safeclient.start";

    public static final String ACTION_FORCE_UPDATE_DISMISS = "com.xdja.upgrade.dismiss";

    @Override
    public void onReceive(Context context, Intent intent) {

        String action = intent.getAction();

        switch (action) {
            case ACTION_APP_START:

                RXDConfig rxdConfig = StorageIO.readRxdConfig(context);
                if (rxdConfig == null) {
                    return;
                }
                if (rxdConfig.isForceUpdate()) {
                    AlertDialogWrapper dialogWrapper = new AlertDialogWrapper(context, true);
                    dialogWrapper.showForceDialog(rxdConfig);
                }
                break;
        }


    }

    public static void onForceUpdateDismiss(Context context) {
        Intent intent = new Intent(ACTION_FORCE_UPDATE_DISMISS);
        context.sendBroadcast(intent);
    }


}
