package com.xdja.upgrade.storage;

import android.content.Context;
import android.util.Xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.ClientVersionXmlTag;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.exception.WriteClientVersionException;

import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by wanghao on 2016/11/23.
 * <ol>
 * <li>读取asserts目录下的ClientVer.xml，转化为UpdateConfig</li>
 * <li>用户写入的数据存入XML</li>
 * <ol/>
 */
public class ClientVersionStorage implements IStorage<ClientVersion> {

    private Context context;

    public static final String TAG = ClientVersionStorage.class.getName();

    public ClientVersionStorage(Context context) {
        this.context = context;
    }

    @Override
    public ClientVersion read(Context context) throws UpdateModuleException {
        ClientVersion clientVersion = null;

        try {
            InputStream is = context.getAssets().open("ClientVer.xml");
            XStream stream = new XStream(new DomDriver());
            stream.processAnnotations(ClientVersion.class);
            clientVersion = (ClientVersion) stream.fromXML(is);
            UpdateLog.d(TAG, clientVersion.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }

        return clientVersion;
    }

    @Override
    public boolean write(Context context, ClientVersion clientVersion, OutputStream outputStream) throws UpdateModuleException {
        try {
            XmlSerializer serializer = Xml.newSerializer(); //获取一个序列化器
            serializer.setOutput(outputStream, "UTF-8");  //设置输出流
            serializer.startDocument("UTF-8", true);    //文件开始标志设置，true代表文件可独立存在

            /***Root  start ***/
            serializer.startTag(null, ClientVersionXmlTag.TAG_ROOT);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_IP_KEY);
            serializer.text(clientVersion.getIp());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_IP_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_PORT_KEY);
            serializer.text(clientVersion.getPort());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_PORT_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_FACTORY_KEY);
            serializer.text(clientVersion.getFactory());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_FACTORY_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_MOD_KEY);
            serializer.text(clientVersion.getMode());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_MOD_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_OS_KEY);
            serializer.text(clientVersion.getOs());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_OS_KEY);


            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_SOFT_KEY);
            serializer.text(clientVersion.getSoft());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_SOFT_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_USERNAME_KEY);
            serializer.text(clientVersion.getUserName());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_USERNAME_KEY);


            /**ver----start**/
            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_VER_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_VERSION_KEY);
            serializer.text(clientVersion.getVer().getVersion());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_VERSION_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_DATE_KEY);
            serializer.text(clientVersion.getVer().getDate());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_DATE_KEY);

            serializer.startTag(null, ClientVersionXmlTag.TAG_SERVER_NOTE_KEY);
            serializer.text(clientVersion.getVer().getNote());
            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_NOTE_KEY);

            serializer.endTag(null, ClientVersionXmlTag.TAG_SERVER_VER_KEY);
            /***ver---- end***/


            serializer.endTag(null, ClientVersionXmlTag.TAG_ROOT);
            /****Root-----end ********/
            serializer.endDocument();
            return true;
        } catch (IOException e) {
            throw new WriteClientVersionException();
        } finally {
            try {
                outputStream.flush();
                outputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
