package com.xdja.upgrade.storage;

import android.content.Context;
import android.util.Xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.bean.RXDConfigXmlTag;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.util.AppUtil;

import org.xmlpull.v1.XmlSerializer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * <pre>
 * Created by wanghao on 2016/11/24.
 * 当前文件默认读取的是用服务端返回数据写入本地的update_s.xml
 * 但是为了对象的重复里面，我们这里还可以指定要读取的文件名比如：update_temp.xml
 * 使用者调用的时候注意在构造函数内选择
 * 也许为了更好的扩展,比如我们需要读取指定的路径下的xml 可以调整对应
 * context.openFileInput(fileName);
 * </pre>
 */
public class RXDStorage implements IStorage<RXDConfig> {

    public static final String TAG = RXDStorage.class.getName();

    private String fileName = "update_s.xml";

    /**
     * <pre>
     * 读取/data/data/packages/files/fileName 文件<br/>
     * 当使用默认构造时读取的是update_s.xml
     * </pre>
     */
    private RXDStorage() {
    }

    /**
     * <pre>
     * 读取/data/data/packages/files/fileName 文件<br/>
     * 当使用默认构造时读取的是update_s.xml
     * @param fileName 要读取的文件名称
     * </pre>
     */
    private RXDStorage(String fileName) {
        this.fileName = fileName;
    }


    /**
     * <pre>
     * 读取/data/data/packages/files/fileName 文件<br/>
     * 当使用默认构造时读取的是update_s.xml
     * </pre>
     */
    public static RXDConfig readDefaultXml(Context context) throws UpdateModuleException {
        return new RXDStorage().read(context);
    }

    public static RXDConfig readTempXml(Context context) throws UpdateModuleException {
        String tempFile = "update_temp.xml";
        return new RXDStorage(tempFile).read(context);
    }

    /**
     * 删除默认的xml配置文件
     *
     * @return
     */
    public static boolean deleteDefaultXml(Context context) {
        File originalFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        return originalFile.delete();
    }

    /**
     * 重写默认路径下的update_s.xml
     *
     * @param rxdConfig
     * @return
     * @throws Exception
     */
    public static boolean writeDefaultXml(Context context, RXDConfig rxdConfig) throws Exception {
        File localVersion = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        OutputStream outputStream = new FileOutputStream(localVersion);
        return new RXDStorage().write(context, rxdConfig, outputStream);
    }


    @Override
    public RXDConfig read(Context context) throws UpdateModuleException {

        RXDConfig rxdConfig = null;

        try {
            FileInputStream in = new FileInputStream(context.getFilesDir().getPath() + "/" + fileName);

            XStream stream = new XStream(new DomDriver());
            stream.processAnnotations(RXDConfig.class);

            rxdConfig = (RXDConfig) stream.fromXML(in);
            UpdateLog.d(TAG, "读取到update_s信息", rxdConfig.toString());

        } catch (IOException e) {
            e.printStackTrace();
        }


        return rxdConfig;
    }

    @Override
    public boolean write(Context context, RXDConfig rxdConfig, OutputStream outputStream) throws UpdateModuleException {

        try {

            XmlSerializer serializer = Xml.newSerializer(); //获取一个序列化器
            serializer.setOutput(outputStream, "UTF-8");  //设置输出流
            serializer.startDocument("UTF-8", true);    //文件开始标志设置，true代表文件可独立存在

            /***Root  start ***/
            serializer.startTag(null, RXDConfigXmlTag.TAG_ROOT);

            serializer.startTag(null, RXDConfigXmlTag.TAG_VERSION);
            serializer.text(rxdConfig.getUpdate().getVersion());
            serializer.endTag(null, RXDConfigXmlTag.TAG_VERSION);


            serializer.startTag(null, RXDConfigXmlTag.TAG_DATE);
            serializer.text(rxdConfig.getUpdate().getDate());
            serializer.endTag(null, RXDConfigXmlTag.TAG_DATE);

            serializer.startTag(null, RXDConfigXmlTag.TAG_DATE);
            serializer.text(rxdConfig.getUpdate().getDate());
            serializer.endTag(null, RXDConfigXmlTag.TAG_DATE);


            serializer.startTag(null, RXDConfigXmlTag.TAG_COMMENT);
            serializer.text(rxdConfig.getUpdate().getComment());
            serializer.endTag(null, RXDConfigXmlTag.TAG_COMMENT);

            serializer.startTag(null, RXDConfigXmlTag.TAG_UPDATE_TAG);
            serializer.text(rxdConfig.getUpdate().getUpdateTag());
            serializer.endTag(null, RXDConfigXmlTag.TAG_UPDATE_TAG);

            /***tag  files **/
            serializer.startTag(null, RXDConfigXmlTag.TAG_FILES);

            for (com.xdja.upgrade.bean.update_s_bean.File updateServerFile : rxdConfig.getUpdate().getFiles().getFiles()) {// 文件列表

                serializer.startTag(null, RXDConfigXmlTag.TAG_FILE);

                serializer.startTag(null, RXDConfigXmlTag.TAG_REMOTE_PATH);
                serializer.text(updateServerFile.getRemotePath());
                serializer.endTag(null, RXDConfigXmlTag.TAG_REMOTE_PATH);


                serializer.startTag(null, RXDConfigXmlTag.TAG_LOCAL_PATH);
                serializer.text(updateServerFile.getLocalPath());
                serializer.endTag(null, RXDConfigXmlTag.TAG_LOCAL_PATH);


                serializer.startTag(null, RXDConfigXmlTag.TAG_FILE_NAME);
                serializer.text(updateServerFile.getFileName());
                serializer.endTag(null, RXDConfigXmlTag.TAG_FILE_NAME);

                serializer.startTag(null, RXDConfigXmlTag.TAG_FILE_SIZE);
                serializer.text(String.valueOf(updateServerFile.getFileSize()));
                serializer.endTag(null, RXDConfigXmlTag.TAG_FILE_SIZE);


                serializer.startTag(null, RXDConfigXmlTag.TAG_ACTION);
                serializer.text(updateServerFile.getAction());
                serializer.endTag(null, RXDConfigXmlTag.TAG_ACTION);


                serializer.startTag(null, RXDConfigXmlTag.TAG_STATE);
                serializer.text(updateServerFile.getState());
                serializer.endTag(null, RXDConfigXmlTag.TAG_STATE);

                serializer.startTag(null, RXDConfigXmlTag.TAG_DOWNLOAD_SIZE);
                serializer.text(String.valueOf(updateServerFile.getDownloadSize()));
                serializer.endTag(null, RXDConfigXmlTag.TAG_DOWNLOAD_SIZE);

                serializer.startTag(null, RXDConfigXmlTag.TAG_DELETE_DB);
                serializer.text(updateServerFile.getDeleteDb());
                serializer.endTag(null, RXDConfigXmlTag.TAG_DELETE_DB);


                serializer.startTag(null, RXDConfigXmlTag.TAG_CHECK_CODE);
                serializer.text(updateServerFile.getCheckCode());
                serializer.endTag(null, RXDConfigXmlTag.TAG_CHECK_CODE);

                serializer.endTag(null, RXDConfigXmlTag.TAG_FILE);
            }


            serializer.endTag(null, RXDConfigXmlTag.TAG_FILES);


            serializer.endTag(null, RXDConfigXmlTag.TAG_ROOT);
            /****Root-----end ********/
            serializer.endDocument();
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        } finally {
            try {
                outputStream.flush();
                outputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
