package com.xdja.upgrade.storage;

import android.content.Context;
import android.content.SharedPreferences;

import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.ClientVersionXmlTag;
import com.xdja.upgrade.exception.UpdateModuleException;

import java.io.OutputStream;

/**
 * Created by wanghao on 2016/11/23.
 * <ol>
 * <li>读取写入shared文件，转化为UpdateConfig</li>
 * <li>用户写入的数据存入shared文件</li>
 * <ol/>
 */
public class SharedStorage implements IStorage {

    @Override
    public ClientVersion read(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(ClientVersionXmlTag.TAG_UPDATE_CONFIG, Context.MODE_PRIVATE);
        return new ClientVersion().readConfig(sharedPreferences);
    }

    @Override
    public boolean write(Context context, Object o, OutputStream outputStream) throws UpdateModuleException {
        return false;
    }

    public boolean writeConfig(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(ClientVersionXmlTag.TAG_UPDATE_CONFIG, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(key, value);
        return editor.commit();
    }


}
