package com.xdja.upgrade.storage;

import android.content.Context;

import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.bean.update_s_bean.Update;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.util.AppUtil;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 读取或者写入升级服务器对应的配置策略
 * 在此对常用的几个xml对应的对象进行封装
 * <ol>
 * <li>读取写入shared文件，转化为UpdateConfig</li>
 * <li>用户写入的数据存入shared文件</li>
 * <li>读取写入XML文件，转化为UpdateConfig</li>
 * <li>用户写入的数据存入XML</li>
 * <ol/>
 */
public class StorageIO {

    /**
     * 读取客户端版本信息
     *
     * @return
     * @throws UpdateModuleException
     */
    public static ClientVersion readClientVersion(Context context) throws UpdateModuleException {
        ClientVersion clientVersion = new ClientVersionStorage(context).read(context);
        return clientVersion;
    }

    /**
     * <pre>
     * 合并本地update_temp.xml 和 update_s.xml
     * 重新读取update_s.xml数据到UpdateServerConfig
     * </pre>
     */
    public static RXDConfig readRxdConfig(Context context) throws UpdateModuleException {
        File originalFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        File tempFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_temp.xml");
        RXDConfig rxdConfig = RXDStorage.readDefaultXml(context);
        if (tempFile.exists()) {
            RXDConfig tempRxdConfig = RXDStorage.readTempXml(context);
            if (!rxdConfig.getUpdate().getVersion().equals(tempRxdConfig.getUpdate().getVersion())) {
                originalFile.delete();
                //王浩注释 2016-12-02重构
                /*SharedPreferences sharePre = context.getSharedPreferences("mxtchat", 0);
                String fname = sharePre.getString("MainFileName", "");
                if (!fname.equals("")) {
                    File tfile = new File(AppUtil.getAppAbsolutePath(context) + "/" + fname);
                    if (tfile.exists()) {
                        tfile.delete();
                    }
                }*/
                tempFile.renameTo(originalFile);
                return RXDStorage.readDefaultXml(context);
            } else {
                tempFile.delete();
            }
        }
        return rxdConfig;
    }

    /*
    * 写文件
    */
    private static void writeFile(String filename, byte[] data, boolean append) throws UpdateModuleException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filename, append);
            fileOutputStream.write(data);
            fileOutputStream.flush();
        } catch (IOException e) {
            throw new UpdateModuleException(e);
        } finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } catch (IOException e) {
                throw new UpdateModuleException(e);
            }
        }
    }

    /**
     * 写入文件
     *
     * @param fileName
     * @param data
     * @param append
     */
    public static void writeFile(String fileName, String data, boolean append) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName, append);
            out.write(data.getBytes());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeFileAppend(String filename, byte[] data, int byteCount) throws UpdateModuleException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(filename, true);
            out.write(data, 0, byteCount);
            out.flush();
            out.close();
        } catch (Exception e) {
            throw new UpdateModuleException(e);
        }
    }


    /*
    * 解析版本升级确认信息
    */
    public static int parseConfirmInfo(byte[] confirmInfo) {
        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();// 取版本升级确认信息
                return Integer.parseInt(result);
            } else {
                return -1;
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    /**
     * 检测update_s.xml文件是否存在
     *
     * @param context
     * @return
     */
    public static boolean isUpdateSExist(Context context) {
        return new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml").exists();
    }

    public static boolean deleteUpdateTemp(Context context) {
        return new File(AppUtil.getAppAbsolutePath(context) + "/update_temp.xml").delete();
    }

    /**
     * 删除rxd文件，也就是update_s.xml文件
     *
     * @return
     */
    public static boolean deleteUpdateS(Context context) {
        File rxdConfig = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        return rxdConfig.delete();
    }

    public static void writeUpdateTemp(Context context, byte[] data) {
        String filePath = AppUtil.getAppAbsolutePath(context) + "/update_temp.xml";
        writeFile(filePath, data, false);
    }

    public static void writeUpdateS(Context context, byte[] data) {
        String filePath = AppUtil.getAppAbsolutePath(context) + "/update_s.xml";
        writeFile(filePath, data, false);
    }

    /**
     * 删除rxd文件，也就是update_s.xml文件
     *
     * @return
     */
    public static boolean deleteRxdConfig(Context context) {
        return deleteUpdateS(context);
    }

    /**
     * 重写update_s文件
     *
     * @param context
     * @param config
     */
    public static void rewriteUpdateS(Context context, RXDConfig config) {

        Update update = config.getUpdate();

        StringBuilder file = new StringBuilder();
        file.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        file.append("<Root>");

        file.append("<Version>");
        file.append(update.getVersion());
        file.append("</Version>");

        file.append("<Date>");
        file.append(update.getDate());
        file.append("</Date>");

        file.append("<Comment>");
        file.append(update.getComment());
        file.append("</Comment>");

        file.append("<UpdateTag>");
        file.append(update.getUpdateTag());
        file.append("</UpdateTag>");

        file.append("<Files>");

        List<com.xdja.upgrade.bean.update_s_bean.File> fileList = update.getFiles().getFiles();
        int fileListNum = fileList.size();
        com.xdja.upgrade.bean.update_s_bean.File fi;
        for (int i = 0; i < fileListNum; i++) {// 文件列表
            fi = fileList.get(i);
            file.append("<File>");

            file.append("<RPath>");
            file.append(fi.getRemotePath());
            file.append("</RPath>");

            file.append("<LPath>");
            file.append(fi.getLocalPath());
            file.append("</LPath>");

            file.append("<FName>");
            file.append(fi.getFileName());
            file.append("</FName>");

            file.append("<FSize>");
            file.append(fi.getFileSize());
            file.append("</FSize>");

            file.append("<Action>");
            file.append(fi.getAction());
            file.append("</Action>");

            file.append("<State>");
            file.append(fi.getState());
            file.append("</State>");

            file.append("<CSize>");
            file.append(fi.getDownloadSize());
            file.append("</CSize>");

            file.append("<DeleteDb>");
            file.append(fi.getDeleteDb());
            file.append("</DeleteDb>");

            file.append("<CheckCode>");
            file.append(fi.getCheckCode());
            file.append("</CheckCode>");

            file.append("</File>");
        }

        file.append("</Files>");
        file.append("</Root>");

        String fileName = AppUtil.getAppAbsolutePath(context) + "/update_s.xml";
        writeFile(fileName, file.toString(), false);
    }


}
