package com.xdja.upgrade.task;

import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RequestHead;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.util.UpdateConfigConst;

/**
 * 版本检测请求使用的Socket
 * Created by wanghao on 2016/12/2.
 */
public class ClientVersionSocket extends SocketService {

    public ClientVersionSocket(ClientVersion clientVersion) {
        super(clientVersion);
    }

    @Override
    protected String getHeader() {
        return RequestHead.buildRequest(clientVersion);
    }


    @Override
    protected SocketResult parseResponseHeader(byte[] rxd) {
        UpdateLog.d(TAG, "解析返回数据头");
        int result = StorageIO.parseConfirmInfo(rxd);
        UpdateLog.d(TAG, "数据头正常判断 解析数据头结果:" + result);
        switch (result) {
            case 0:
                UpdateLog.d(TAG, "数据头正常 再次获取socket数据 获取数据正常判断");
                byte[] dataArray = recvData();
                if (dataArray == null) {
                    UpdateLog.d(TAG, "再次获取数据异常，为空");
                    return new SocketResult(UpdateConfigConst.CODE_SEND_DATA);
                } else {
                    UpdateLog.d(TAG, "再次获取数据正常");
                    return new SocketResult(UpdateConfigConst.CODE_DEFAULT_SUCCESS, dataArray);
                }
//                剩下的都是数据头异常
//                这个1、2、3、4和-1是原来服务端定义的状态码
//                我们会把它对应转换成我们客户端自定的状态码
            case 1:
                UpdateLog.d(TAG, "解析数据头结果:无升级版本");
                return new SocketResult(UpdateConfigConst.CODE_NO_NEWER_VERSION);
            case 2:
                UpdateLog.d(TAG, "解析数据头结果:当前终端无配置信息");
                return new SocketResult(UpdateConfigConst.CODE_SERVER_LOCAL_NOT_CONFIG);
            case 3:
                UpdateLog.d(TAG, "解析数据头结果:查询升级配置失败");
                return new SocketResult(UpdateConfigConst.CODE_SERVER_QUERY_CONFIG);
            case 4:
                UpdateLog.d(TAG, "解析数据头结果:升级配置文件不存在");
                return new SocketResult(UpdateConfigConst.CODE_SERVER_CONFIG_FILE_NOT_EXIST);
            case -1:
                UpdateLog.d(TAG, "解析数据头结果:无法解析升级确认信息");
                return new SocketResult(UpdateConfigConst.CODE_SERVER_CAN_NOT_PARSE_CONFIG);
        }
        UpdateLog.d(TAG, "升级模块：启动Socket流程 未知错误");
        return new SocketResult(UpdateConfigConst.CODE_UNKNOWN);
    }


}
