package com.xdja.upgrade.task;

import android.content.Context;
import android.widget.Toast;

import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.ContextNullException;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;

/**
 * 暂时废弃，由VersionCheckTask代替
 * <pre>
 * Created by wanghao on 2016/11/23.
 * 检测更新版本
 * 默认不显示loading,如果调用者需要显示loading @see ClientVersionTask#setIsShowLoading
 * 使用方式如下 new ClientVersionTask().template();
 * </pre>
 *
 * @see ClientVersionTask#setIsShowLoading(boolean)
 */
@Deprecated
public class ClientVersionTask extends UpdateModuleTask<String, Integer, Integer> {

    public static final String TAG = ClientVersionTask.class.getName();

    private boolean isShowLoading;

    private ProgressDialogWrapper progressDialogWrapper;

    public ClientVersionTask(Context context) throws UpdateModuleException {
        super(context);
    }


    @Override
    public void template() throws ContextNullException {
        if (context == null) {
            throw new ContextNullException();
        } else {
            this.progressDialogWrapper = new ProgressDialogWrapper(context).setIsShowLoading(isShowLoading);
//            execute();
        }
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        progressDialogWrapper.showLoading();
    }

    @Override
    protected Integer doInBackground(String... params) {
        SocketService socketService = null;
        try {
            //升级模块：检测版本更新1 读取ip和端口号
            ClientVersion clientVersion = StorageIO.readClientVersion(context);
            if (clientVersion == null) {
                UpdateToast.show(context, "null");
                return UpdateConfigConst.CODE_UNKNOWN;
            }
            //升级模块：检测版本更新1 读取已安装版本号
            String installedVersion = AppUtil.getCurrentVersion(context);
            boolean isNull = installedVersion == null;
            UpdateLog.d(TAG, "installVersion", String.valueOf(isNull));

            if (!clientVersion.getVer().getVersion().equals(installedVersion)) {

            }

            //升级模块：检测版本更新 启动Socket流程
            socketService = new ClientVersionSocket(clientVersion);

            SocketService.SocketResult socketResult = socketService.executeSocket();
//            Log.d(AppUtil.TAG, socketResult.getResultCode() + "的状态码");\
            //升级模块：启动Socket流程 获取数据正常
            //成功，继续流程
            if (socketResult.getResultCode() == UpdateConfigConst.CODE_DEFAULT_SUCCESS) {
                //
                byte[] data = socketResult.getResultBytes();
                //升级模块：启动Socket流程 删除Update_temp.xml
                StorageIO.deleteUpdateTemp(context);
                //升级模块：update_s.xml是否存在
                if (StorageIO.isUpdateSExist(context)) {
                    //升级模块：启动Socket流程 存在，socket数据写入update_temp.xml
                    StorageIO.writeUpdateTemp(context, data);
                } else {
                    //升级模块：启动Socket流程 不存在，socket数据写入update_s.xml
                    StorageIO.writeUpdateS(context, data);
                }
            }
            return socketResult.getResultCode();
        } catch (UpdateModuleException e) {
            return UpdateConfigConst.CODE_UNKNOWN;
        } finally {
            if (socketService != null) {
                socketService.close();
            }
        }
    }

    @Override
    protected void onPostExecute(Integer result) {
        super.onPostExecute(result);
        progressDialogWrapper.dismiss();
        //升级模块：启动Socket流程 是否写入数据异常
        //不是默认成功的情况下，显示失败信息
        if (result != UpdateConfigConst.CODE_DEFAULT_SUCCESS) {
            String warning = UpdateConfigConst.ConfigWrapper.getErrorDescription(result);
            Toast.makeText(context, warning, Toast.LENGTH_SHORT).show();
        } else {
            try {
                //升级模块：启动Socket流程 读取本地获取到的升级文件update_s.xml 或update_temp.xml
                RXDConfig rxdConfig = StorageIO.readRxdConfig(context);
                AlertDialogWrapper alertDialogWrapper = new AlertDialogWrapper(context, isShowLoading);
                alertDialogWrapper.showDialog(rxdConfig);
            } catch (UpdateModuleException e) {
                e.printStackTrace();
            }
        }
    }

    public void setIsShowLoading(boolean isShowLoading) {
        this.isShowLoading = isShowLoading;
    }
}
