package com.xdja.upgrade.task;

import android.content.Context;
import android.util.Log;

import com.xdja.upgrade.NetWorkUtil;
import com.xdja.upgrade.R;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.ClientVersionStorage;
import com.xdja.upgrade.storage.RXDStorage;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AlgUtil;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.TaskManager;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;

import java.io.File;
import java.util.List;

/**
 * Description:
 * apk下载任务
 * Created by zjc on 2017/6/5 0005.
 */
public class DownloadApkTask extends CommonTask<String, Integer, Integer> {

    public static final String TAG = DownloadApkTask.class.getName();

    //onPostExecute是在MainThread中进行回调的，doInBackground是WorkerThread

    RXDConfig config;

    RxdApkSocket socketService;

    ClientVersion clientVersion;

    List<com.xdja.upgrade.bean.update_s_bean.File> filesList;

    ProgressDialogWrapper dialog;

    @Override
    public String getTaskName() {
        return DownloadApkTask.class.getName();
    }

    public DownloadApkTask(Context context, RXDConfig config) {
        super(context);
        this.config = config;
        this.filesList = config.getUpdate().getFiles().getFiles();
        this.clientVersion = new ClientVersionStorage(context).read(context);
        this.socketService = new RxdApkSocket(context, clientVersion).setRXDConfig(config);
        dialog = new ProgressDialogWrapper(context, true);
    }

    public DownloadApkTask(Context context, RXDConfig config, ClientVersion clientVersion) {
        this(context,config);
        this.clientVersion = clientVersion;
        this.socketService = new RxdApkSocket(context, clientVersion).setRXDConfig(config);
    }



    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        UpdateLog.d(TAG, "开始下载流程 显示滚动条");
        dialog.showDownloading();
    }

    @Override
    protected Integer doInBackground(String... params) {
        UpdateLog.d(TAG, "解析update_s.xml的文件集为空判断");
        if (filesList != null) {

            int fileSum = filesList.size();
            UpdateLog.d(TAG, "检测本地已下载数据大小");
            for (int i = 0; i < fileSum; i++) {
                com.xdja.upgrade.bean.update_s_bean.File updateServerFile = filesList.get(i);

                long downloadedSize = updateServerFile.getDownloadSize();
                long serverFileSIze = updateServerFile.getFileSize();

                Log.d(TAG, "已下载大小：" + downloadedSize + " 服务器目标文件大小：" + serverFileSIze);
                if (downloadedSize >= serverFileSIze) {
                    UpdateLog.d(TAG, "不启动下载流程，启动校验已下载包");
                    int result = checkApk(updateServerFile);
                    if (result != UpdateConfigConst.SUCCESS) {
                        //这个地方经测试，如果MD5校验失败，及时不删除源文件，直接下载覆写文件也是可以的
                        download(updateServerFile);
                        return result;
                    }
                } else {
                    //已下载数据比服务器端文件小
                    UpdateLog.d(TAG, "已有下载进程判断");
                    //继续之前的下载流程实际上就是什么都不做
                    if (isDownloading()) {
                        UpdateLog.d(TAG, "下载进行正在进行中, 判断网络环境是否是wifi");
                        // TODO: 2017/6/14 0014 下面这个条件判断可以简化
                        if (NetWorkUtil.isWifi(context)) {
                            UpdateLog.d(TAG, "网络环境是wifi, 强制升级判断");
                            if (isForceUpdate()) {
                                UpdateLog.d(TAG, "当前版本需要强制升级，不提示用户，继续之前的下载流程");
                            } else {
                                UpdateLog.d(TAG, "当前版本不需要强制升级，提示用户正在下载，继续之前的下载流程");
                                UpdateToast.show(context, R.string.downloading);
                            }
                        } else {
                            UpdateLog.d(TAG, "网络环境不是wifi，提示用户正在下载，继续之前下载流程");
                            UpdateToast.show(context, R.string.downloading);
                        }

                    } else {
                        UpdateLog.d(TAG, "没有正在进行中的下载进程");
                        download(updateServerFile);
                    }
                }

            }

        } else {
            UpdateLog.d(TAG, "update_s.xml的文件集为空");
            return UpdateConfigConst.CODE_NO_FILE_TO_UPDATE;
        }
        return UpdateConfigConst.SUCCESS;
    }

    /**
     * 启动Socket进行下载
     *
     * @param updateServerFile
     * @return
     */
    private int download(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        UpdateLog.d(TAG, "启动socket连接");
        long downloadedSize = updateServerFile.getDownloadSize();
        //判断本地文件大小与已下载的xml文件中获取的大小是否相同
        //如果不相同，将本地文件的大小重新作为请求值
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
        if (file.exists()) {
            long localFileSize = file.length();
            UpdateLog.d(TAG, "本地文件大小：" + localFileSize + " 已下载文件大小：" + downloadedSize);
            if (localFileSize != downloadedSize) {
                updateServerFile.setDownloadSize(file.length());
            }
        }
        // TODO: 2017/6/14 0014 这个是断点续传用的吗？
        socketService.setUpdateServerFile(updateServerFile);

        SocketService.SocketResult result = socketService.executeSocket();
        UpdateLog.d(TAG, "获取数据正常判断", result.getResultCode() + " ", UpdateConfigConst.ConfigWrapper.getErrorDescription(result.getResultCode()));
        if (result.getResultCode() == UpdateConfigConst.SUCCESS) {
            UpdateLog.d(TAG, "下载请求成功");
            //下载成功，数据写入apk文件
            try {
                return writeApkFile(updateServerFile);
            } catch (UpdateModuleException e) {
                return UpdateConfigConst.ERROR;
            }

        } else {
//            boolean success = StorageIO.deleteUpdateS(context);
            UpdateLog.d(TAG, "获取数据异常，删除update_s.xml", "错误码：", result.getResultCode() + "");

            int errorCode = result.getResultCode();
            if (errorCode == UpdateConfigConst.CODE_CON_SERVER || errorCode == UpdateConfigConst.CODE_SEND_DATA || errorCode == UpdateConfigConst.CODE_ACCEPT_DATA_TIMEOUT) {
//                重写update_s.xml
                StorageIO.rewriteUpdateS(context, config);
            }

            // TODO: 2017/6/13 0013 这里有个Toast不知道为什么不显示
            UpdateToast.show(context, SocketService.getResultMessage(result.getResultCode()));
            return UpdateConfigConst.ERROR;
        }
    }

    /**
     * 校验安装包MD5
     *
     * @param updateServerFile
     * @return
     */
    private int checkApk(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
        UpdateLog.d(TAG, "安装包存在判断");
        if (file.exists()) {
            UpdateLog.d(TAG, "安装包存在 校验包MD5");
            try {
                String md5 = AlgUtil.getMD5Hash(file);
                if (md5.equals(updateServerFile.getCheckCode())) {
                    UpdateLog.d(TAG, "MD5校验成功 进入安装流程");
                    return UpdateConfigConst.SUCCESS;
                } else {
                    UpdateLog.d(TAG, "MD5校验失败");
                    //安装流程中，如果哈希校验失败，是删除apk文件的。下载流程的apk校验先和安装流程统一
                    file.delete();
                    return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
                }
            } catch (Exception e) {
                e.printStackTrace();
                return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
            }
        } else {
            UpdateLog.d(TAG, "安装包不存在");
            return UpdateConfigConst.CODE_DOWNLOAD_FILE_NOT_EXIST;
        }

    }

    @Override
    protected void onPostExecute(Integer resultCode) {
        super.onPostExecute(resultCode);

        dialog.dismiss();

        if (resultCode == UpdateConfigConst.SUCCESS) {
            UpdateLog.d(TAG, "安装对应apk");
            InstallTask task = new InstallTask(context, config);
            task.execute();
        } else {
            String errorMsg = UpdateConfigConst.ConfigWrapper.getErrorDescription(resultCode);
            UpdateLog.d(TAG, "写入文件出错，错误码" + resultCode + ":" + errorMsg);
//            UpdateToast.show(context, errorMsg);
            AlertDialogWrapper.downloadFailureDialog(context);
        }

        //这个地方需要删除，否则下次点击更新的时候会崩溃
        //原因是xml转换错误，因为update_s.xml的数据被修改了
        StorageIO.deleteUpdateS(context);
    }

    private boolean isDownloading() {
        return TaskManager.getInstance().isTaskRunning(this);
    }

    private boolean isForceUpdate() {
        return config.isForceUpdate();
    }

    /**
     * 从socket对象读取数据，写入文件到本地
     *
     * @param updateServerFile
     * @return
     */
    private int writeApkFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        UpdateLog.d(TAG, "Socket数据写入本地开始");
        File downloadingFile = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
        int fileSize = (int) updateServerFile.getFileSize();
        int downloadedSize = (int) updateServerFile.getDownloadSize();
        UpdateLog.d(TAG, "已下载大小：" + downloadedSize + " 服务器目标文件大小：" + fileSize);
        String fileName = updateServerFile.getFileName();
        //修改权限放在循环内会执行多次，为了保证只执行一次且执行时文件存在，在外面加个变量控制
        boolean modifyPermission = false;
        //因为接下来的循环会执行很多次，所以流程图里的日志在读写正常情况下不再打印
        while (downloadedSize < fileSize) {
//            UpdateLog.d(TAG, "已下载数据小于文件总大小");
            int bucket = fileSize - downloadedSize;
            byte[] data = new byte[bucket];
            int currentLen;
            try {
//                UpdateLog.d(TAG, "Socket数据读入数组");
                //每次读取到的数据大小
                currentLen = socketService.read(data, 0, bucket);
                if (currentLen == -1) {
                    UpdateLog.d(TAG, "Socket数据读取异常" + config.toString());
                    // TODO: 2017/6/14 0014 这个应该相当于原来的rewrite，还有写入大小大于等于文件总大小判断写一行的write
                    RXDStorage.writeDefaultXml(context, config);
                    // TODO: 2017/6/15 0015 4，接收升级文件数据超时，重写update_s.xml
                    StorageIO.rewriteUpdateS(context, config);
                    return UpdateConfigConst.CODE_DOWNLOAD_RXD_TIMEOUT;
                } else {
//                    UpdateLog.d(TAG, "Socket数据读取正常");
                    try {
                        downloadedSize += currentLen;
                        //通知界面更新进度条
                        publishProgress((int) ((downloadedSize / (float) fileSize) * 100), downloadedSize);
                        //将byte数组以流的方式写入文件
                        StorageIO.writeFileAppend(AppUtil.getAppAbsolutePath(context) + "/" + fileName, data, currentLen);
//                        UpdateLog.d(TAG, "修改文件权限");
                        if (!modifyPermission) {
                            Runtime.getRuntime().exec("chmod 644 " + AppUtil.getAppAbsolutePath(context) + "/" + fileName);
                            modifyPermission = true;
                        }
                        if (downloadedSize >= fileSize) {
                            updateServerFile.setState(UpdateConfigConst.DownloadState.DOWNLOADED);
                            UpdateLog.d(TAG, "写入大小大于等于文件总大小判断：是");
                            // TODO: 2017/6/15 0015 6，本地文件大小大于配置文件大小，重写状态为2，重写update_s.xml
                            StorageIO.rewriteUpdateS(context, config);
                            String md5Hash = AlgUtil.getMD5Hash(AppUtil.getAppAbsolutePath(context) + "/" + fileName);
                            if (!md5Hash.equals(updateServerFile.getCheckCode())) {
                                UpdateLog.d(TAG, "校验包md5异常, 删除文件");
                                downloadingFile.delete();
                                return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
                            }
                        } else {
//                            UpdateLog.d(TAG, "正在写入" + config.toString());
                            // TODO: 2017/6/14 0014 这个状态重写
                            // TODO: 2017/6/15 0015  7，本地文件大小小于配置文件大小，重写状态为1，重写update_s.xml
                            updateServerFile.setState(UpdateConfigConst.DownloadState.DOWNLOADING);
//                            RXDStorage.writeDefaultXml(context, config);
                            StorageIO.rewriteUpdateS(context, config);
                        }
                    } catch (Exception e) {
                        UpdateLog.d(TAG, "数据写入异常，删除已下载文件" + config.toString());
                        downloadingFile.delete();
                        updateServerFile.setState(UpdateConfigConst.DownloadState.UNDOWNLOAD);
                        updateServerFile.setDownloadSize(0l);
                        // TODO: 2017/6/15 0015 5，升级文件写入错误,重写update_s.xml
                        StorageIO.rewriteUpdateS(context, config);
                        return UpdateConfigConst.CODE_DOWNLOAD_WRITE_FILE_ERROR;
                    }
                }
            } catch (Exception e) {
                return UpdateConfigConst.CODE_DOWNLOAD_RXD_TIMEOUT;
            }
        }
        UpdateLog.d(TAG, "apk写入成功");
        return UpdateConfigConst.SUCCESS;
    }

    /**
     * 更新进度
     * value[0] 下载百分比
     * value[1] 下载大小
     *
     * @param values
     */
    @Override
    protected void onProgressUpdate(Integer... values) {
        super.onProgressUpdate(values);
        dialog.setProgress(values[0]);
//        UpdateLog.d(TAG, "进度" + values[0]);
    }
}
