package com.xdja.upgrade.task;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;

import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.SPUtil;
import com.xdja.upgrade.util.TaskManager;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;

/**
 * Description:
 * apk安装task
 * Created by zjc on 2017/6/7 0007.
 */
public class InstallTask extends CommonTask<Void, Void, Void> {

    public static final String TAG = InstallTask.class.getName();

    public static final String FORCE_UPDATE_RESULT = "force_update_result";

    RXDConfig config;

    String filename;

    public InstallTask(Context context, RXDConfig config) {
        super(context);
        this.config = config;
        initFileName();
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        UpdateLog.d(TAG, "apk安装开始");
    }

    @Override
    public String getTaskName() {
        return null;
    }

    @Override
    protected Void doInBackground(Void... params) {
        UpdateLog.d(TAG, "检测当前是否已有安装流程");
        if (!isInstalling()) {
            TaskManager.getInstance().putTask(this);
            UpdateLog.d(TAG, "检测是否是强制升级");
            if (forceUpdate()) {
                if (!isSystemSigned()) {
                    UpdateLog.d(TAG, "需要强制升级，没有系统签名，提示用户安装");
                    //如果用户取消安装的话，下次登录需要强制用户进行安装
                } else {
                    UpdateLog.d(TAG, "需要强制升级，有系统签名，静默安装");
                    installSilienclly(AppUtil.getAppAbsolutePath(context) + "/" + filename);
                }

            } else {
                UpdateLog.d(TAG, "不需要强制升级，提示用户安装");
                install();
            }

        } else {
            UpdateLog.d(TAG, "有APK正在进行安装,终止当前动作，等待之前的安装流程完成");
            //终止当前动作，等待之前的安装流程完成；什么都不用做

        }
        return null;
    }

    public boolean forceUpdate() {
        return config.isForceUpdate();
    }

    /**
     * 是否有正在进行中的安装流程
     *
     * @return
     */
    public boolean isInstalling() {
        return TaskManager.getInstance().isTaskRunning(this);
    }

    //是否有系统签名
    public boolean isSystemSigned() {
        return false;
    }

    //显式安装
    private void install() {
        UpdateLog.d(TAG, "显示安装");
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setDataAndType(Uri.fromFile(new File(AppUtil.getAppAbsolutePath(context) + "/" + filename)),
                "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    //静默安装
    private void installSilienclly(String apkPath) {
        String cmd = "pm install -r " + apkPath;
        Process process = null;
        DataOutputStream os = null;
        BufferedReader successResult = null;
        BufferedReader errorResult = null;
        StringBuilder successMsg = new StringBuilder("success");
        StringBuilder errorMsg = new StringBuilder("error");
        try {
            //静默安装需要root权限
            process = Runtime.getRuntime().exec("su");
//            process = Runtime.getRuntime().exec("chmod 777" + apkPath);
            process = Runtime.getRuntime().exec(cmd);
            os = new DataOutputStream(process.getOutputStream());
            os.write(cmd.getBytes());
            os.writeBytes("\n");
            os.writeBytes("exit\n");
            os.flush();
            //执行命令
            process.waitFor();
            //获取返回结果
            successResult = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String s;
            while ((s = successResult.readLine()) != null) {
                successMsg.append(s);
            }
            while ((s = errorResult.readLine()) != null) {
                errorMsg.append(s);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (process != null) {
                    process.destroy();
                }
                if (successResult != null) {
                    successResult.close();
                }
                if (errorResult != null) {
                    errorResult.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }


        UpdateLog.d(TAG, "静默安装结果" + successMsg.toString() + "\n" + errorMsg.toString());
    }

    @Override
    protected void onPostExecute(Void aVoid) {
        super.onPostExecute(aVoid);
        TaskManager.getInstance().removeTask(this);
        Toast.makeText(context, "安装完成", Toast.LENGTH_SHORT).show();
    }

    private void initFileName() {
        List files = config.getUpdate().getFiles().getFiles();
        com.xdja.upgrade.bean.update_s_bean.File file = (com.xdja.upgrade.bean.update_s_bean.File) files.get(files.size() - 1);
        filename = file.getFileName();
    }

    /**
     * 检测强制更新是否完成
     * 如果未完成，提示用户必须更新，否则会退出应用
     *
     * @return
     */
    public boolean checkForceInstallResult() {
        return (boolean) SPUtil.get(context, FORCE_UPDATE_RESULT, false);
    }

    public void setForceUpdateSuccess() {
        SPUtil.put(context, FORCE_UPDATE_RESULT, true);
    }

    public void setForceUpdateFailed() {
        SPUtil.put(context, FORCE_UPDATE_RESULT, false);
    }


}
