package com.xdja.upgrade.task;

import android.content.Context;

import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.bean.RequestHead;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.UpdateConfigConst;

import java.io.File;

/**
 * 下载apk所用的socket
 * Created by wanghao on 2016/12/2.
 */
public class RxdApkSocket extends SocketService {

    Context context;

    RXDConfig rxdConfig;

    com.xdja.upgrade.bean.update_s_bean.File updateServerFile;

    public RxdApkSocket(Context context, ClientVersion clientVersion) {
        super(clientVersion);
        this.context = context;
    }

    public RxdApkSocket setRXDConfig(RXDConfig rxdConfig) {
        this.rxdConfig = rxdConfig;
        return this;
    }

    public RxdApkSocket setUpdateServerFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        this.updateServerFile = updateServerFile;
        return this;
    }


    @Override
    protected String getHeader() {
        return RequestHead.buildBreakPointTransmition(updateServerFile);
    }

    @Override
    protected SocketResult parseResponseHeader(byte[] rxd) {
        int result = StorageIO.parseConfirmInfo(rxd);
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        switch (result) {
            case 0:
                new SocketResult(UpdateConfigConst.SUCCESS,rxd);
                break;
            case 1:
                file.delete();
                return new SocketResult(UpdateConfigConst.CODE_DOWNLOAD_FILE_NOT_EXIST);
            case 2:
                file.delete();
                return new SocketResult(UpdateConfigConst.CODE_DOWNLOAD_READ_FILE_ERROR);
            case 3:
                file.delete();
                return new SocketResult(UpdateConfigConst.CODE_DOWNLOAD_FILE_SIZE_DIFF);
            case 4:
                file.delete();
                return new SocketResult(UpdateConfigConst.CODE_DOWNLOAD_OFFSET_INVALID);
            case 5:
                file.delete();
                return new SocketResult(UpdateConfigConst.CODE_DOWNLOAD_PARAM_ERROR);
        }
        return new SocketResult(UpdateConfigConst.SUCCESS);
    }
}
