package com.xdja.upgrade.task;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.ContextNullException;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.ClientVersionStorage;
import com.xdja.upgrade.storage.RXDStorage;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AlgUtil;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.UpdateConfigConst;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

/**
 * 暂时废弃，由DownloadApkTask代替
 * Created by wanghao on 2016/11/23.
 */
public class RxdApkTask extends UpdateModuleTask<String, Integer, Integer> {

    Context context;

    RXDConfig rxdConfig;

    ClientVersion clientVersion;

    RxdApkSocket socketService;

    List<com.xdja.upgrade.bean.update_s_bean.File> filesList;

    ProgressDialogWrapper progressDialogWrapper;


    @Override
    public void template() throws ContextNullException {
        if (context == null) {
            throw new ContextNullException();
        } else {
            this.progressDialogWrapper = new ProgressDialogWrapper(context).setIsForceUpdate(rxdConfig.isForceUpdate());
            execute();
        }
    }

    public RxdApkTask(Context context, RXDConfig rxdConfig) throws UpdateModuleException {
        super(context);
        this.context = context;
        this.rxdConfig = rxdConfig;
        this.filesList = rxdConfig.getUpdate().getFiles().getFiles();
        this.clientVersion = new ClientVersionStorage(context).read(context);
        this.socketService = new RxdApkSocket(context, clientVersion).setRXDConfig(rxdConfig);
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        progressDialogWrapper.showDownloading();
    }

    @Override
    protected Integer doInBackground(String... strings) {
        //升级模块：子流程-开始下载 解析update_s.xml的文件集是否为空
        if (filesList.isEmpty()) {
            RXDStorage.deleteDefaultXml(context);
            return UpdateConfigConst.CODE_NO_FILE_TO_UPDATE;
        } else {
            int fileSum = filesList.size();
            for (int i = 0; i < fileSum; i++) {
                com.xdja.upgrade.bean.update_s_bean.File updateServerFile = filesList.get(i);
                //王浩注释 2016-12-02重构
                /*if (i == fileSum - 1) {
                    SharedPreferences.Editor share = context.getSharedPreferences("mxtchat", 0).edit();
                    share.putString("MainFileName", updateServerFile.getFileName()); // 识别程序的文件名，以后删除用，否则会永久不删除
                    share.putString("DeleteDb", updateServerFile.getDeleteDb()); // 是否删除数据库文件
                    share.apply();
                }*/
                //升级模块：子流程-开始下载 检测本地已下载数据大小
                if (updateServerFile.getDownloadSize() == updateServerFile.getFileSize()) {
                    return validateLocalFile(updateServerFile);
                }

                if (updateServerFile.getDownloadSize() < updateServerFile.getFileSize()) {
                    //2017/5/22 0022 缺一个先检测是否有下载流程正在进行
                    File file = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
                    if (file.exists()) {
                        if (file.length() != updateServerFile.getDownloadSize()) {
                            updateServerFile.setDownloadSize(file.length());
                        }
                    }
                    socketService.setUpdateServerFile(updateServerFile);
                    SocketService.SocketResult socketResult = socketService.executeSocket();
                    if (socketResult.getResultCode() != UpdateConfigConst.SUCCESS) {
                        try {
                            RXDStorage.writeDefaultXml(context, rxdConfig);
                        } catch (Exception e) {
                            return UpdateConfigConst.ERROR;
                        }
                    } else {
                        return writeApkFile(updateServerFile);
                    }
                    return socketResult.getResultCode();
                } else {
                    //2017/5/22 0022  之后添加大于的情况下，进入安装流程

                }
            }
            return UpdateConfigConst.SUCCESS;
        }
    }


    @Override
    protected void onPostExecute(Integer result) {
        super.onPostExecute(result);
        progressDialogWrapper.dismiss();
        socketService.close();
        if (result != UpdateConfigConst.SUCCESS) {
            AlertDialogWrapper.downloadFailureDialog(context);
        } else {
            for (com.xdja.upgrade.bean.update_s_bean.File updateServerFile : filesList) {
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.setDataAndType(Uri.fromFile(new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName())), "application/vnd.android.package-archive");
                context.startActivity(intent);
            }
        }
        try {
            processRemainedFiles(context);
        } catch (Exception e) {
            new UpdateModuleException(e);
        }
    }

    /**
     * @param updateServerFile
     * @return 0 : 成功  其他:失败
     * @see UpdateConfigConst#SUCCESS
     * @see UpdateConfigConst#CODE_DOWNLOAD_HASH_ERROR
     * @see UpdateConfigConst#CODE_DOWNLOAD_FILE_NOT_EXIST
     */
    //wanghao 这里逻辑还需要再次梳理
    private int validateLocalFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
        if (file.exists()) {
            try {
                String md5Hash = AlgUtil.getMD5Hash(file);
                if (!md5Hash.equals(updateServerFile.getCheckCode())) {
                    file.delete();
                    return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
                }
                return UpdateConfigConst.SUCCESS;
            } catch (Exception e) {
                return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
            }
        } else {
            StorageIO.deleteRxdConfig(context);
            return UpdateConfigConst.CODE_DOWNLOAD_FILE_NOT_EXIST;
        }
    }


    /**
     * 从socket对象读取数据，写入文件到本地
     *
     * @param updateServerFile
     * @return
     */
    private int writeApkFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File downloadingFile = new File(AppUtil.getAppAbsolutePath(context) + "/" + updateServerFile.getFileName());
        int fileSize = (int) updateServerFile.getFileSize();
        int downloadedSize = (int) updateServerFile.getDownloadSize();
        String fileName = updateServerFile.getFileName();
        while (downloadedSize < fileSize) {
            int bucket = fileSize - downloadedSize;
            byte[] data = new byte[bucket];
            int currentLen;
            try {
                currentLen = socketService.read(data, 0, bucket);
                if (currentLen == -1) {
                    RXDStorage.writeDefaultXml(context, rxdConfig);
                    return UpdateConfigConst.CODE_DOWNLOAD_RXD_TIMEOUT;
                } else {
                    try {
                        downloadedSize += currentLen;
                        publishProgress((int) ((downloadedSize / (float) fileSize) * 100));
                        StorageIO.writeFileAppend(AppUtil.getAppAbsolutePath(context) + "/" + fileName, data, currentLen);
                        Runtime.getRuntime().exec("chmod 644 " + AppUtil.getAppAbsolutePath(context) + "/" + fileName);
                        if (downloadedSize >= fileSize) {
                            updateServerFile.setState(UpdateConfigConst.DownloadState.DOWNLOADED);
                            RXDStorage.writeDefaultXml(context, rxdConfig);
                            String md5Hash = AlgUtil.getMD5Hash(AppUtil.getAppAbsolutePath(context) + "/" + fileName);
                            if (!md5Hash.equals(updateServerFile.getCheckCode())) {
                                downloadingFile.delete();
                                return UpdateConfigConst.CODE_DOWNLOAD_HASH_ERROR;
                            }
                        } else {
                            updateServerFile.setState(UpdateConfigConst.DownloadState.DOWNLOADING);
                            RXDStorage.writeDefaultXml(context, rxdConfig);
                        }
                    } catch (Exception e) {
                        downloadingFile.delete();
                        updateServerFile.setState(UpdateConfigConst.DownloadState.UNDOWNLOAD);
                        updateServerFile.setDownloadSize(0l);
                        RXDStorage.writeDefaultXml(context, rxdConfig);
                        return UpdateConfigConst.CODE_DOWNLOAD_WRITE_FILE_ERROR;
                    }
                }
            } catch (Exception e) {
                return UpdateConfigConst.CODE_DOWNLOAD_RXD_TIMEOUT;
            }
        }
        return UpdateConfigConst.SUCCESS;
    }

    /**
     * 处理升级过程中残余的文件
     * 1 删除update_s.xml
     * 2 当前的version和ClientVer.xml内的数据进行比较 不一致则重写
     *
     * @throws Exception
     */
    private void processRemainedFiles(Context context) throws Exception {
        File file = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        file.delete();
        String versionName = AppUtil.getCurrentVersion(context);
        if (!versionName.equals(clientVersion.getVer().getVersion())) {
            clientVersion.getVer().setVersion(versionName);
            File localVersion = new File(AppUtil.getAppAbsolutePath(context) + "/ClientVer.xml");
            OutputStream outputStream = new FileOutputStream(localVersion);
            new ClientVersionStorage(context).write(context, clientVersion, outputStream);
        }
    }

}
