package com.xdja.upgrade.task;

import android.content.Context;

import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.UpgradeSettingCallback;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.TaskManager;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;

/**
 * Description:
 * 版本检测的任务
 * Created by zjc on 2017/6/1 0001.
 */
public class VersionCheckTask extends CommonTask<String, Integer, Integer> {

    public static final String TAG = VersionCheckTask.class.getName();

    boolean alreadyRunning;

    public VersionCheckTask(Context context) {
        super(context);
        progress.setIsShowLoading(true);
        alreadyRunning = TaskManager.isCheckRunning();
        UpdateLog.d(TAG, "alreadyRunning:" + alreadyRunning);
        if (!alreadyRunning) {
            TaskManager.setCheckRunning(true);
        }
    }

    UpgradeSettingCallback settingCallback;

    public VersionCheckTask(Context context, UpgradeSettingCallback callback){
        this(context);
        this.settingCallback = callback;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        if (alreadyRunning) {
            onPostExecute(TASK_IS_RUNNING);
        }
        progress.showLoading();
    }

    @Override
    public String getTaskName() {
        return VersionCheckTask.class.getName();
    }

    @Override
    protected Integer doInBackground(String... params) {

        SocketService socketService = null;
        boolean writeSuccess = false;
        try {
            UpdateLog.d(TAG, "读取ip和端口号");
            ClientVersion version;
            if(settingCallback != null){
                version = settingCallback.getDefineBean();
            }else {
                version = StorageIO.readClientVersion(context);
            }
            if (version != null) {
                UpdateLog.d(TAG, "当前配置信息", version.toString());
            } else {
                UpdateLog.d(TAG, "配置为空", String.valueOf(version == null));
            }

            UpdateLog.d(TAG, "读取已安装的包的版本号");
            String installedVersion = AppUtil.getCurrentVersion(context);
            UpdateLog.d(TAG, "版本号为空" + String.valueOf(installedVersion == null), "当前版本号：", installedVersion);

            UpdateLog.d(TAG, "启动Socket连接");

            socketService = new ClientVersionSocket(version);
            SocketService.SocketResult result = socketService.executeSocket();

            if (result.getResultCode() == UpdateConfigConst.CODE_DEFAULT_SUCCESS) {

                UpdateLog.d(TAG, "删除update_temp.xml");
                boolean deleteSuccess = StorageIO.deleteUpdateTemp(context);
                UpdateLog.d(TAG, "删除结果：" + deleteSuccess);

                UpdateLog.d(TAG, "update_s.xml是否存在");
                if (StorageIO.isUpdateSExist(context)) {
                    UpdateLog.d(TAG, "存在，socket数据写入update_temp.xml");
                    StorageIO.writeUpdateTemp(context, result.getResultBytes());
                } else {
                    UpdateLog.d(TAG, "不存在,Socket数据写入update_s.xml");
                    StorageIO.writeUpdateS(context, result.getResultBytes());
                }
                UpdateLog.d(TAG, "写入文件正常");
                writeSuccess = true;
            }
            return result.getResultCode();
        } catch (UpdateModuleException e) {
            //如果读写文件失败的话，是会抛出这个异常的
            //所以暂时根据这个异常判断流程中是否写入数据异常
            writeSuccess = false;
            return UpdateConfigConst.CODE_UNKNOWN;
        } finally {
            if (socketService != null) {
                socketService.close();
            }
            UpdateLog.d(TAG, "是否写入数据异常：" + writeSuccess);
        }

    }

    @Override
    protected void onPostExecute(Integer resultCode) {
        super.onPostExecute(resultCode);
        progress.dismiss();
        if (resultCode == TASK_IS_RUNNING) {
            UpdateLog.d("alreadyRunning", "检测任务正在进行中");
        } else {
            UpdateLog.d(TAG, "执行结果" + resultCode);
            try {
                if (resultCode == UpdateConfigConst.CODE_DEFAULT_SUCCESS) {
                    UpdateLog.d(TAG, "读取本地获取到的升级文件update_s.xml 或update_temp.xml");
                    RXDConfig rxdConfig = StorageIO.readRxdConfig(context);
                    UpdateLog.d(TAG, "读取到的配置信息", rxdConfig.toString());
                    //弹出对话框提示升级
                    UpdateLog.d("alreadyRunning", "弹出对话框");
                    AlertDialogWrapper dialog = new AlertDialogWrapper(context, true);
                    //TODO wanghao xjq  再次重构，目前为了测试需要添加 dialog.showDialog()重载
                    if(settingCallback != null){
                        dialog.showDialog(rxdConfig,settingCallback.getDefineBean());
                    }else {
                        dialog.showDialog(rxdConfig);
                    }

                } else {
                    UpdateLog.d(TAG, "socket流程异常");
                    UpdateToast.show(context, UpdateConfigConst.ConfigWrapper.getErrorDescription(resultCode));
                }
            } catch (UpdateModuleException e) {
                e.printStackTrace();
            }
        }

    }


}
