package com.xdja.upgrade.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;

import com.xdja.upgrade.R;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.receiver.UpdateReceiver;
import com.xdja.upgrade.task.DownloadApkTask;
import com.xdja.upgrade.util.TaskManager;

/**
 * <pre>
 * Created by wanghao on 2016/11/24.
 * 处理对应的更新提示框
 * 1 用户确认框
 * 2 强制升级框提示
 * </pre>
 */
public class AlertDialogWrapper {

    private Context context;

    private boolean isShowLoading;

    public AlertDialogWrapper(Context context, boolean isShowLoading) {
        this.context = context;
        this.isShowLoading = isShowLoading;
    }

    /**
     * 显示更新提示框
     *
     * @param rxdConfig
     */
    public void showDialog(RXDConfig rxdConfig) {
        if (isShowLoading) {
            if (rxdConfig.isForceUpdate()) {
                showForceDialog(rxdConfig);
            } else {
                showAlertDialog(rxdConfig);
            }
        } else {
            downloadApk(rxdConfig);
        }
    }

    public void showDialog(RXDConfig rxdConfig, ClientVersion clientVersion){
        if (isShowLoading) {
            if (rxdConfig.isForceUpdate()) {
                showForceDialog(rxdConfig,clientVersion);
            } else {
                showAlertDialog(rxdConfig,clientVersion);
            }
        } else {
            downloadApk(rxdConfig,clientVersion);
        }
    }


    //启动下载apk动作
    private void downloadApk(RXDConfig rxdConfig) {
        try {
            DownloadApkTask task = new DownloadApkTask(context, rxdConfig);
            task.execute();
        } catch (UpdateModuleException e) {
            e.printStackTrace();
        }
    }


    //启动下载apk动作
    private void downloadApk(RXDConfig rxdConfig,ClientVersion... clientVersions) {
        try {
            DownloadApkTask task = new DownloadApkTask(context, rxdConfig,clientVersions[0]);
            task.execute();
        } catch (UpdateModuleException e) {
            e.printStackTrace();
        }
    }


    /***
     * 提示版本升级
     */
    void showAlertDialog(final RXDConfig rxdConfig,final ClientVersion... clientVersions) {
        String title = context.getResources().getString(R.string.soft_update);
        String resMessage = context.getResources().getString(R.string.dialog_proposed_update_message);
        String message = String.format(resMessage, rxdConfig.getUpdate().getVersion(), rxdConfig.getUpdate().getComment());
        String positiveBtn = context.getResources().getString(R.string.update_text);
        String negativeBtn = context.getResources().getString(R.string.temp_not_update_text);

        Dialog dialog = new AlertDialog.Builder(context).setTitle(title).setMessage(message)
                .setPositiveButton(positiveBtn,
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int which) {
                                TaskManager.setCheckRunning(false);
                                UpdateLog.d("alreadyRunning", "alreadyRunning:重置为false");
                                downloadApk(rxdConfig,clientVersions);
                                dialog.dismiss();
                            }
                        }).setNegativeButton(negativeBtn, new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int whichButton) {
                                TaskManager.setCheckRunning(false);
                                UpdateLog.d("alreadyRunning", "alreadyRunning:重置为false");
                                dialog.dismiss();
                            }
                        }
                ).create();
        dialog.setCancelable(false);
        dialog.show();
    }

    /**
     * 强制更新提示框
     */
    public void showForceDialog(final RXDConfig rxdConfig,final ClientVersion... clientVersions) {

        String title = context.getResources().getString(R.string.soft_update);
        String resMessage = context.getResources().getString(R.string.dialog_force_update_message);
        String message = String.format(resMessage, rxdConfig.getUpdate().getVersion(), rxdConfig.getUpdate().getComment());
        String updateBtn = context.getResources().getString(R.string.update_text);
        String exitBtn = context.getResources().getString(R.string.exit_text);
        Dialog dialog = new AlertDialog.Builder(context).setTitle(title).setMessage(message)
                .setPositiveButton(updateBtn,
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int which) {
                                TaskManager.setCheckRunning(false);
                                UpdateLog.d("alreadyRunning", "alreadyRunning:重置为false");
                                downloadApk(rxdConfig,clientVersions);
                                dialog.dismiss();
                            }
                        }).setNegativeButton(exitBtn, new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int whichButton) {
                        UpdateLog.d("alreadyRunning", "alreadyRunning:重置为false");
                        dialog.dismiss();
                        UpdateReceiver.onForceUpdateDismiss(context);
                        //强制更新的情况下，点击去掉，整个应用结束，这个交由应用调用方进行处理
                        //下次应用启动时，更新模块进行监听。如果需要强制更新，则提示强制更新的对话框
                        //监听在UpdateReceiver中进行实现
                    }
                }).create();
        dialog.setCancelable(false);
        dialog.show();

    }

    /**
     * 下载apk出错提示
     */
    public static void downloadFailureDialog(Context context) {
        final AlertDialog.Builder alertBuilder = new AlertDialog.Builder(context);
        alertBuilder.setTitle(context.getResources().getString(R.string.confirm_tips));
        alertBuilder.setMessage(context.getResources().getString(R.string.download_failure_message));
        alertBuilder.setPositiveButton(context.getResources().getString(R.string.confirm_ok), new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dlg, int which) {

            }
        });
        alertBuilder.setCancelable(false);
        alertBuilder.create().show();

    }

}
