package com.xdja.upgrade.ui;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;

/**
 * 更新客户端。检测客户端时 显示loading
 * Created by wanghao on 2016/11/24.
 * 注意这里我们在task内使用时不要重复new对象这里要记得控制一下
 */
public class ProgressDialogWrapper {

    private boolean isForceUpdate;

    private boolean isShowLoading;

    private Context context;

    private ProgressDialog mDialog;

    public ProgressDialogWrapper(Context context) {
        this.context = context;
    }

    public ProgressDialogWrapper(Context context, boolean isShowLoading) {
        this.context = context;
        this.isShowLoading = isShowLoading;
    }

    public ProgressDialogWrapper setIsShowLoading(boolean isShowLoading) {
        this.isShowLoading = isShowLoading;
        return this;
    }

    public ProgressDialogWrapper setIsForceUpdate(boolean isForceUpdate) {
        this.isForceUpdate = isForceUpdate;
        return this;
    }


    /***
     * 检测版本显示loading
     */
    public void showLoading() {
        if (isShowLoading) {
            mDialog = new ProgressDialog(context);
            mDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
            mDialog.setTitle("连接中");
            mDialog.setMessage("正在检测版本，请稍候");
            mDialog.setCancelable(false);
            mDialog.show();
        }
    }


    /**
     * 下载apk 文件时调用当前函数显示loading
     */
    public void showDownloading() {
        if (isShowLoading) {
            mDialog = new ProgressDialog(context);
            mDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            mDialog.setTitle("提示");
            mDialog.setMessage("正在下载升级文件,请稍候");
            if (isForceUpdate) {
                mDialog.setButton(DialogInterface.BUTTON_NEGATIVE, "取消", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int i) {
                        dialog.cancel();
                    }
                });
            }
            mDialog.setMax(100);
            mDialog.setIndeterminate(false);
            mDialog.setCancelable(false);
            mDialog.show();
        }
    }

    public void dismiss() {
        if (mDialog != null) {
            mDialog.dismiss();
        }
    }

    public void setProgress(int downloadPercent) {
        if (mDialog != null) {
            mDialog.setProgress(downloadPercent);
        }
    }

}
