package com.xdja.upgrade.util;

import com.xdja.upgrade.exception.Md5ValidateException;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;

/**
 * Created by wanghao on 2016/11/29.
 * 封装算法实现
 */
public class AlgUtil {

    static char[] hexChar = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};


   public static String getMD5Hash(String filePath) throws Md5ValidateException {
       try {
           return getMD5Hash(new File(filePath));
       }catch (Exception e){
           throw new Md5ValidateException();
       }
    }

    public static String getMD5Hash(File file) throws Exception {
        InputStream fis = new FileInputStream(file);// 读取文件
        byte[] buffer = new byte[1024];
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        int numRead;
        while ((numRead = fis.read(buffer)) > 0) {
            md5.update(buffer, 0, numRead);
        }
        fis.close();
        return toHexString(md5.digest());
    }

    static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; i++) {
            sb.append(hexChar[(b[i] & 0xf0) >>> 4]);
            sb.append(hexChar[b[i] & 0x0f]);
        }
        return sb.toString();
    }


}
