package com.xdja.upgrade.util;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;

/**
 * Description:自动更新检测
 * Created by zjc on 2017/5/17 0017.
 */
public class CountdownUtil {

    public static final String UPDATE_TIME = "update_time";

    public static long THREE_DAY = 3600 * 3 * 1000;

    /**
     * 距离上次检测时间是否超过三天
     * 这个判断会在认证成功后进行
     *
     * @param context
     * @return
     */
    public static boolean needUpdate(Context context) {
        long current = System.currentTimeMillis();
        long last = getLastUpdateCheckDate(context);
        //每次判断是否更新之后，都会重置之间标志
        resetAlarm(context);

        //判断间隔是否大于72小时
        return ((current - last) / 3600 / 1000) > 72;
    }

    /**
     * 获取上次更新检测的时间
     *
     * @param context
     * @return
     */
    private static long getLastUpdateCheckDate(Context context) {
        return (long) SPUtil.get(context, UPDATE_TIME, 0);
    }

    /**
     * 记录此次更新时间
     *
     * @param context
     */
    private static void logThisTime(Context context) {
        SPUtil.put(context, UPDATE_TIME, System.currentTimeMillis());
    }

    private static void setNextUpdateTime(Context context) {

        PendingIntent intent = getAlarmIntent(context);

        AlarmManager alarm = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        alarm.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + THREE_DAY, intent);

    }

    /**
     * 记录时间
     * 取消唤醒Alarm
     * 设置下次更新时间
     *
     * @param context
     */
    private static void resetAlarm(Context context) {
        logThisTime(context);
        cancelAlarm(context);
        setNextUpdateTime(context);
    }

    private static void cancelAlarm(Context context) {
        AlarmManager alarm = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
        alarm.cancel(getAlarmIntent(context));
    }

    private static PendingIntent getAlarmIntent(Context context) {
        return PendingIntent.getBroadcast(context, 0, new Intent(), PendingIntent.FLAG_ONE_SHOT);
    }


}
