package com.xdja.upgrade.util;

import com.xdja.upgrade.task.CommonTask;

import java.util.HashMap;
import java.util.Map;

/**
 * Update模块任务管理
 * 防止统一类型任务启动多个
 * Created by wanghao on 2016/12/1.
 */
public class TaskManager {

    public static final String TAG = TaskManager.class.getName();

    public static final Map<String, CommonTask> taskMap = new HashMap<>();

    private static TaskManager taskManager = new TaskManager();

    private static boolean checkRunning = false;

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        return taskManager;
    }

    public void putTask(CommonTask task) {
        taskMap.put(task.getTaskName(), task);
    }

    public void removeTask(CommonTask task) {
        taskMap.remove(task.getTaskName());
    }

    public boolean isTaskRunning(String taskName) {
        return taskMap.get(taskName) != null;
    }

    public boolean isTaskRunning(CommonTask task) {
        return isTaskRunning(task.getTaskName());
    }

    public static boolean isCheckRunning() {
        return checkRunning;
    }

    public static void setCheckRunning(boolean running) {
        checkRunning = running;
    }


}
