package com.xdja.upgrade.util;

import java.util.HashMap;
import java.util.Map;

/**
 * 服务器返回的状态码和客户端转换的自定义状态码
 * Created by wanghao on 2016/11/23.
 */
public class UpdateConfigConst {

    public static class DownloadState {

        public static final String UNDOWNLOAD = "0";

        public static final String DOWNLOADING = "1";

        public static final String DOWNLOADED = "2";

    }

    public static final int SUCCESS = 0;

    public static final int ERROR = -1;

    public static final int CODE_DEFAULT_SUCCESS = -100;

    public static final int CODE_UNKNOWN = CODE_DEFAULT_SUCCESS - 1;

    public static final String ERROR_UNKNOWN = "未知错误";

    public static final int CODE_IP_NOT_SET = CODE_DEFAULT_SUCCESS - 2;

    public static final String ERROR_IP_NOT_SET = "未设置升级服务器地址";

    public static final int CODE_PORT_NOT_SET = CODE_DEFAULT_SUCCESS - 3;

    public static final String ERROR_PORT_NOT_SET = "未设置升级服务器端口";
    /**
     * IP解析（转换）错误
     */
    public static final int CODE_IP_PARSE = CODE_DEFAULT_SUCCESS - 4;

    public static final String ERROR_IP_PARSE = "解析升级服务器域名出错";
    /**
     * 连接服务器失败
     */
    public static final int CODE_CON_SERVER = CODE_DEFAULT_SUCCESS - 5;

    public static final String ERROR_CON_SERVER = "连接升级服务器失败";

    /**
     * 请求异常
     */
    public static final int CODE_SEND_DATA = CODE_DEFAULT_SUCCESS - 6;

    public static final String ERROR_SEND_DATA = "发送数据失败";
    /**
     * 读取返回数据异常
     */
    public static final int CODE_ACCEPT_DATA_TIMEOUT = CODE_DEFAULT_SUCCESS - 7;

    public static final String ERROR_ACCEPT_DATA_TIMEOUT = "接收升级确认信息超时";

    /**
     * 无升级版本
     */
    public static final int CODE_NO_NEWER_VERSION = CODE_DEFAULT_SUCCESS - 8;

    public static final String ERROR_SERVER_NOT_VERSION = "无升级版本";

    /**
     * 当前终端无配置信息
     */
    public static final int CODE_SERVER_LOCAL_NOT_CONFIG = CODE_DEFAULT_SUCCESS - 9;

    public static final String ERROR_SERVER_LOCAL_NOT_CONFIG = "当前终端无配置信息";

    /**
     * 查询升级配置失败
     */
    public static final int CODE_SERVER_QUERY_CONFIG = CODE_DEFAULT_SUCCESS - 10;

    public static final String ERROR_SERVER_QUERY_CONFIG = "查询升级配置失败";

    /**
     * 升级配置文件不存在
     */
    public static final int CODE_SERVER_CONFIG_FILE_NOT_EXIST = CODE_DEFAULT_SUCCESS - 11;

    public static final String ERROR_SERVER_CONFIG_FILE_NOT_EXIST = "升级配置文件不存在";

    /**
     * 无法解析升级确认信息
     */
    public static final int CODE_SERVER_CAN_NOT_PARSE_CONFIG = CODE_DEFAULT_SUCCESS - 12;

    public static final String ERROR_SERVER_CAN_NOT_PARSE_CONFIG = "无法解析升级确认信息";

    public static final int CODE_DOWNLOAD_SOCKET_CLOSED = CODE_DEFAULT_SUCCESS - 13;

    public static final int CODE_DOWNLOAD_RXD_TIMEOUT = CODE_DEFAULT_SUCCESS - 14;

    public static final String ERROR_DOWNLOAD_RXD_TIMEOUT = "接收Socket数据异常";

    public static final int CODE_DOWNLOAD_WRITE_FILE_ERROR = CODE_DEFAULT_SUCCESS - 15;

    public static final String ERROR_CODE_DOWNLOAD_WRITE_FILE_ERROR = "写入数据异常";
    /**
     * APK MD5 哈希校验失败
     */
    public static final int CODE_DOWNLOAD_HASH_ERROR = CODE_DEFAULT_SUCCESS - 16;

    public static final String ERROR_DOWNLOAD_HASH_ERROR = "哈希校验失败";

    /**
     * 文件不存在
     */
    public static final int CODE_DOWNLOAD_FILE_NOT_EXIST = CODE_DEFAULT_SUCCESS - 17;

    public static final String ERROR_DOWNLOAD_FILE_NOT_EXIST = "文件不存在";


    public static final int CODE_DOWNLOAD_READ_FILE_ERROR = CODE_DEFAULT_SUCCESS - 18;

    public static final String ERROR_DOWNLOAD_READ_FILE_ERROR = "读取文件失败";


    public static final int CODE_DOWNLOAD_FILE_SIZE_DIFF = CODE_DEFAULT_SUCCESS - 19;

    public static final String ERROR_DOWNLOAD_FILE_SIZE_DIFF = "文件大小不附";

    public static final int CODE_DOWNLOAD_OFFSET_INVALID = CODE_DEFAULT_SUCCESS - 20;

    public static final String ERROR_DOWNLOAD_OFFSET_INVALID = "指定偏移量无效";

    public static final int CODE_DOWNLOAD_PARAM_ERROR = CODE_DEFAULT_SUCCESS - 21;

    public static final String ERROR_DOWNLOAD_PARAM_ERROR = "参数不完整";

    public static final int CODE_NO_FILE_TO_UPDATE = CODE_DEFAULT_SUCCESS - 22;

    public static final String ERROR_NO_FILE_TO_UPDATE = "文件集为空";


    /********
     * 以下错误信息的提示都是基于服务端返回的数据给出的错误提示
     ********************/


    public static class ConfigWrapper {
        static Map<Integer, String> CONFIG_INFO_MAP = new HashMap<Integer, String>();

        static {
            CONFIG_INFO_MAP.put(CODE_UNKNOWN, ERROR_UNKNOWN);
            CONFIG_INFO_MAP.put(CODE_IP_NOT_SET, ERROR_IP_NOT_SET);
            CONFIG_INFO_MAP.put(CODE_PORT_NOT_SET, ERROR_PORT_NOT_SET);
            CONFIG_INFO_MAP.put(CODE_IP_PARSE, ERROR_IP_PARSE);
            CONFIG_INFO_MAP.put(CODE_CON_SERVER, ERROR_CON_SERVER);
            CONFIG_INFO_MAP.put(CODE_SEND_DATA, ERROR_SEND_DATA);
            CONFIG_INFO_MAP.put(CODE_ACCEPT_DATA_TIMEOUT, ERROR_ACCEPT_DATA_TIMEOUT);
            CONFIG_INFO_MAP.put(CODE_NO_NEWER_VERSION, ERROR_SERVER_NOT_VERSION);
            CONFIG_INFO_MAP.put(CODE_SERVER_LOCAL_NOT_CONFIG, ERROR_SERVER_LOCAL_NOT_CONFIG);
            CONFIG_INFO_MAP.put(CODE_SERVER_QUERY_CONFIG, ERROR_SERVER_QUERY_CONFIG);
            CONFIG_INFO_MAP.put(CODE_SERVER_CONFIG_FILE_NOT_EXIST, ERROR_SERVER_CONFIG_FILE_NOT_EXIST);
            CONFIG_INFO_MAP.put(CODE_SERVER_CAN_NOT_PARSE_CONFIG, ERROR_SERVER_CAN_NOT_PARSE_CONFIG);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_RXD_TIMEOUT, ERROR_DOWNLOAD_RXD_TIMEOUT);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_WRITE_FILE_ERROR, ERROR_CODE_DOWNLOAD_WRITE_FILE_ERROR);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_HASH_ERROR, ERROR_DOWNLOAD_HASH_ERROR);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_FILE_NOT_EXIST, ERROR_DOWNLOAD_FILE_NOT_EXIST);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_READ_FILE_ERROR, ERROR_DOWNLOAD_READ_FILE_ERROR);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_FILE_SIZE_DIFF, ERROR_DOWNLOAD_FILE_SIZE_DIFF);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_OFFSET_INVALID, ERROR_DOWNLOAD_OFFSET_INVALID);
            CONFIG_INFO_MAP.put(CODE_DOWNLOAD_PARAM_ERROR, ERROR_DOWNLOAD_PARAM_ERROR);
            CONFIG_INFO_MAP.put(CODE_NO_FILE_TO_UPDATE, ERROR_NO_FILE_TO_UPDATE);
        }

        public static String getErrorDescription(Integer key) {
            return CONFIG_INFO_MAP.get(key);
        }
    }
}
