package com.xdja.upgrade.util;

import android.content.Context;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 通过配置文件update_config.xml读取升级服务器ip和port
 */

public class UpgradeIPConfig {

    /**
     * 获取升级服务器配置
     * @param mCon  系统的Context
     * @param fileDir  升级地址配置本地路径
     * @return
     */
    public static ArrayList<String> getUpdateConfig(Context mCon, String fileDir) {
        DocumentBuilderFactory docBuilderFactory;
        DocumentBuilder docBuilder;
        Document doc;
        ArrayList<String> IP_Port = new ArrayList<>();
        String updateIP = "";
        String updatePort = "";

        createUpgradeConfig(mCon, fileDir + "/upgrade_config.xml");

        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(fileDir + "/" + "/upgrade_config.xml");
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                updateIP = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP
            }
            nodeList = root.getElementsByTagName("ServerPort");
            if (nodeList.item(0).getFirstChild() != null) {
                updatePort = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器Port
            }
            IP_Port.add(updateIP);
            IP_Port.add(updatePort);
            in.close();
        } catch (Exception ex) {
            ex.printStackTrace();

        } finally {

            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return IP_Port;

    }

    /**
     *
     * 本地配置信息不存在，移动assets目录下相应的文件到本地
     * @param mContext  系统Context
     * @param filename  私有目录文件绝对路径
     */
    @SuppressWarnings("static-access")
    public static void createUpgradeConfig(Context mContext, String filename) {

        if (!(new File(filename).exists())) {

            InputStream in;
            FileOutputStream out;

            try {
                in = mContext.getResources().getAssets().open("upgrade_config.xml");
                out = mContext.openFileOutput("upgrade_config.xml", mContext.MODE_PRIVATE);
                byte[] buffer = new byte[8192];
                int count;
                // 开始复制文件
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            } catch (Exception ioe) {
                ioe.printStackTrace();
                //5-16 需添加文件初始化失败的提示
                //因为这个文件暂时不用，所以先去掉这个to do说明
            }

        }

    }

}
