/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetWorkUtil {
    private static final String NETWORK_TYPE_WIFI = "WIFI";
    private static final String NETWORK_TYPE_2G = "2G";
    private static final String NETWORK_TYPE_3G = "3G";
    private static final String NETWORK_TYPE_4G = "4G";
    private static final String TAG = "Safe_client";

    public static boolean isNetConnect(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo mobNetInfo = connectivityManager.getNetworkInfo(0);
        NetworkInfo wifiNetInfo = connectivityManager.getNetworkInfo(1);
        Log.i((String)"WANGHAO", (String)("----------wifiNetInfo.isConnected():" + wifiNetInfo.isConnected()));
        Log.i((String)"WANGHAO", (String)("----------wifiNetInfo.isAvailable():" + wifiNetInfo.isAvailable()));
        return wifiNetInfo.isConnected() || mobNetInfo.isConnected();
    }

    public static String getNetworkType(Context context) {
        String strNetworkType = "";
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = NETWORK_TYPE_WIFI;
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = NETWORK_TYPE_2G;
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = NETWORK_TYPE_3G;
                        break;
                    }
                    case 13: {
                        strNetworkType = NETWORK_TYPE_4G;
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? NETWORK_TYPE_3G : _strSubTypeName;
                    }
                }
            }
        }
        return strNetworkType;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static String getHostAddress(String domain) {
        InetAddress inetAddress;
        if (domain == null) {
            return null;
        }
        try {
            inetAddress = InetAddress.getByName(domain);
            if (inetAddress == null) {
                return null;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        return inetAddress.getHostAddress();
    }
}

