/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.storage;

import android.content.Context;
import android.util.Xml;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.exception.WriteClientVersionException;
import com.xdja.upgrade.storage.IStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlSerializer;

public class ClientVersionStorage
implements IStorage<ClientVersion> {
    private Context context;
    public static final String TAG = ClientVersionStorage.class.getName();

    public ClientVersionStorage(Context context) {
        this.context = context;
    }

    @Override
    public ClientVersion read(Context context) throws UpdateModuleException {
        ClientVersion clientVersion = null;
        try {
            InputStream is = context.getAssets().open("ClientVer.xml");
            XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
            stream.processAnnotations(ClientVersion.class);
            clientVersion = (ClientVersion)stream.fromXML(is);
            UpdateLog.d(TAG, clientVersion.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return clientVersion;
    }

    @Override
    public boolean write(Context context, ClientVersion clientVersion, OutputStream outputStream) throws UpdateModuleException {
        try {
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(outputStream, "UTF-8");
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, "Root");
            serializer.startTag(null, "ServerIP");
            serializer.text(clientVersion.getIp());
            serializer.endTag(null, "ServerIP");
            serializer.startTag(null, "ServerPort");
            serializer.text(clientVersion.getPort());
            serializer.endTag(null, "ServerPort");
            serializer.startTag(null, "Factory");
            serializer.text(clientVersion.getFactory());
            serializer.endTag(null, "Factory");
            serializer.startTag(null, "Mod");
            serializer.text(clientVersion.getMode());
            serializer.endTag(null, "Mod");
            serializer.startTag(null, "OS");
            serializer.text(clientVersion.getOs());
            serializer.endTag(null, "OS");
            serializer.startTag(null, "Soft");
            serializer.text(clientVersion.getSoft());
            serializer.endTag(null, "Soft");
            serializer.startTag(null, "UserName");
            serializer.text(clientVersion.getUserName());
            serializer.endTag(null, "UserName");
            serializer.startTag(null, "Ver");
            serializer.startTag(null, "Version");
            serializer.text(clientVersion.getVer().getVersion());
            serializer.endTag(null, "Version");
            serializer.startTag(null, "Date");
            serializer.text(clientVersion.getVer().getDate());
            serializer.endTag(null, "Date");
            serializer.startTag(null, "Note");
            serializer.text(clientVersion.getVer().getNote());
            serializer.endTag(null, "Note");
            serializer.endTag(null, "Ver");
            serializer.endTag(null, "Root");
            serializer.endDocument();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new WriteClientVersionException();
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

