/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.storage;

import android.content.Context;
import android.util.Xml;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.IStorage;
import com.xdja.upgrade.util.AppUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlSerializer;

public class RXDStorage
implements IStorage<RXDConfig> {
    public static final String TAG = RXDStorage.class.getName();
    private String fileName = "update_s.xml";

    private RXDStorage() {
    }

    private RXDStorage(String fileName) {
        this.fileName = fileName;
    }

    public static RXDConfig readDefaultXml(Context context) throws UpdateModuleException {
        return new RXDStorage().read(context);
    }

    public static RXDConfig readTempXml(Context context) throws UpdateModuleException {
        String tempFile = "update_temp.xml";
        return new RXDStorage(tempFile).read(context);
    }

    public static boolean deleteDefaultXml(Context context) {
        File originalFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        return originalFile.delete();
    }

    public static boolean writeDefaultXml(Context context, RXDConfig rxdConfig) throws Exception {
        File localVersion = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        FileOutputStream outputStream = new FileOutputStream(localVersion);
        return new RXDStorage().write(context, rxdConfig, (OutputStream)outputStream);
    }

    @Override
    public RXDConfig read(Context context) throws UpdateModuleException {
        RXDConfig rxdConfig = null;
        try {
            FileInputStream in = new FileInputStream(context.getFilesDir().getPath() + "/" + this.fileName);
            XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
            stream.processAnnotations(RXDConfig.class);
            rxdConfig = (RXDConfig)stream.fromXML((InputStream)in);
            UpdateLog.d(TAG, "\u8bfb\u53d6\u5230update_s\u4fe1\u606f", rxdConfig.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rxdConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(Context context, RXDConfig rxdConfig, OutputStream outputStream) throws UpdateModuleException {
        try {
            XmlSerializer serializer = Xml.newSerializer();
            serializer.setOutput(outputStream, "UTF-8");
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, "Root");
            serializer.startTag(null, "Version");
            serializer.text(rxdConfig.getUpdate().getVersion());
            serializer.endTag(null, "Version");
            serializer.startTag(null, "Date");
            serializer.text(rxdConfig.getUpdate().getDate());
            serializer.endTag(null, "Date");
            serializer.startTag(null, "Date");
            serializer.text(rxdConfig.getUpdate().getDate());
            serializer.endTag(null, "Date");
            serializer.startTag(null, "Comment");
            serializer.text(rxdConfig.getUpdate().getComment());
            serializer.endTag(null, "Comment");
            serializer.startTag(null, "UpdateTag");
            serializer.text(rxdConfig.getUpdate().getUpdateTag());
            serializer.endTag(null, "UpdateTag");
            serializer.startTag(null, "Files");
            for (com.xdja.upgrade.bean.update_s_bean.File updateServerFile : rxdConfig.getUpdate().getFiles().getFiles()) {
                serializer.startTag(null, "File");
                serializer.startTag(null, "RPath");
                serializer.text(updateServerFile.getRemotePath());
                serializer.endTag(null, "RPath");
                serializer.startTag(null, "LPath");
                serializer.text(updateServerFile.getLocalPath());
                serializer.endTag(null, "LPath");
                serializer.startTag(null, "FName");
                serializer.text(updateServerFile.getFileName());
                serializer.endTag(null, "FName");
                serializer.startTag(null, "FSize");
                serializer.text(String.valueOf(updateServerFile.getFileSize()));
                serializer.endTag(null, "FSize");
                serializer.startTag(null, "Action");
                serializer.text(updateServerFile.getAction());
                serializer.endTag(null, "Action");
                serializer.startTag(null, "State");
                serializer.text(updateServerFile.getState());
                serializer.endTag(null, "State");
                serializer.startTag(null, "CSize");
                serializer.text(String.valueOf(updateServerFile.getDownloadSize()));
                serializer.endTag(null, "CSize");
                serializer.startTag(null, "DeleteDb");
                serializer.text(updateServerFile.getDeleteDb());
                serializer.endTag(null, "DeleteDb");
                serializer.startTag(null, "CheckCode");
                serializer.text(updateServerFile.getCheckCode());
                serializer.endTag(null, "CheckCode");
                serializer.endTag(null, "File");
            }
            serializer.endTag(null, "Files");
            serializer.endTag(null, "Root");
            serializer.endDocument();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

