/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.storage;

import android.content.Context;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.bean.update_s_bean.Update;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.ClientVersionStorage;
import com.xdja.upgrade.storage.RXDStorage;
import com.xdja.upgrade.util.AppUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StorageIO {
    public static ClientVersion readClientVersion(Context context) throws UpdateModuleException {
        ClientVersion clientVersion = new ClientVersionStorage(context).read(context);
        return clientVersion;
    }

    public static RXDConfig readRxdConfig(Context context) throws UpdateModuleException {
        File originalFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        File tempFile = new File(AppUtil.getAppAbsolutePath(context) + "/update_temp.xml");
        RXDConfig rxdConfig = RXDStorage.readDefaultXml(context);
        if (tempFile.exists()) {
            RXDConfig tempRxdConfig = RXDStorage.readTempXml(context);
            if (!rxdConfig.getUpdate().getVersion().equals(tempRxdConfig.getUpdate().getVersion())) {
                originalFile.delete();
                tempFile.renameTo(originalFile);
                return RXDStorage.readDefaultXml(context);
            }
            tempFile.delete();
        }
        return rxdConfig;
    }

    private static void writeFile(String filename, byte[] data, boolean append) throws UpdateModuleException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filename, append);
            fileOutputStream.write(data);
            fileOutputStream.flush();
        }
        catch (IOException e) {
            throw new UpdateModuleException(e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new UpdateModuleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String data, boolean append) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(fileName, append);
            out.write(data.getBytes());
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void writeFileAppend(String filename, byte[] data, int byteCount) throws UpdateModuleException {
        try {
            FileOutputStream out = new FileOutputStream(filename, true);
            out.write(data, 0, byteCount);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new UpdateModuleException(e);
        }
    }

    public static int parseConfirmInfo(byte[] confirmInfo) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo);
            Document doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();
                return Integer.parseInt(result);
            }
            return -1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public static boolean isUpdateSExist(Context context) {
        return new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml").exists();
    }

    public static boolean deleteUpdateTemp(Context context) {
        return new File(AppUtil.getAppAbsolutePath(context) + "/update_temp.xml").delete();
    }

    public static boolean deleteUpdateS(Context context) {
        File rxdConfig = new File(AppUtil.getAppAbsolutePath(context) + "/update_s.xml");
        return rxdConfig.delete();
    }

    public static void writeUpdateTemp(Context context, byte[] data) {
        String filePath = AppUtil.getAppAbsolutePath(context) + "/update_temp.xml";
        StorageIO.writeFile(filePath, data, false);
    }

    public static void writeUpdateS(Context context, byte[] data) {
        String filePath = AppUtil.getAppAbsolutePath(context) + "/update_s.xml";
        StorageIO.writeFile(filePath, data, false);
    }

    public static boolean deleteRxdConfig(Context context) {
        return StorageIO.deleteUpdateS(context);
    }

    public static void rewriteUpdateS(Context context, RXDConfig config) {
        Update update = config.getUpdate();
        StringBuilder file = new StringBuilder();
        file.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        file.append("<Root>");
        file.append("<Version>");
        file.append(update.getVersion());
        file.append("</Version>");
        file.append("<Date>");
        file.append(update.getDate());
        file.append("</Date>");
        file.append("<Comment>");
        file.append(update.getComment());
        file.append("</Comment>");
        file.append("<UpdateTag>");
        file.append(update.getUpdateTag());
        file.append("</UpdateTag>");
        file.append("<Files>");
        List<com.xdja.upgrade.bean.update_s_bean.File> fileList = update.getFiles().getFiles();
        int fileListNum = fileList.size();
        for (int i = 0; i < fileListNum; ++i) {
            com.xdja.upgrade.bean.update_s_bean.File fi = fileList.get(i);
            file.append("<File>");
            file.append("<RPath>");
            file.append(fi.getRemotePath());
            file.append("</RPath>");
            file.append("<LPath>");
            file.append(fi.getLocalPath());
            file.append("</LPath>");
            file.append("<FName>");
            file.append(fi.getFileName());
            file.append("</FName>");
            file.append("<FSize>");
            file.append(fi.getFileSize());
            file.append("</FSize>");
            file.append("<Action>");
            file.append(fi.getAction());
            file.append("</Action>");
            file.append("<State>");
            file.append(fi.getState());
            file.append("</State>");
            file.append("<CSize>");
            file.append(fi.getDownloadSize());
            file.append("</CSize>");
            file.append("<DeleteDb>");
            file.append(fi.getDeleteDb());
            file.append("</DeleteDb>");
            file.append("<CheckCode>");
            file.append(fi.getCheckCode());
            file.append("</CheckCode>");
            file.append("</File>");
        }
        file.append("</Files>");
        file.append("</Root>");
        String fileName = AppUtil.getAppAbsolutePath(context) + "/update_s.xml";
        StorageIO.writeFile(fileName, file.toString(), false);
    }
}

