/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import android.content.Context;
import android.widget.Toast;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.ContextNullException;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.task.ClientVersionSocket;
import com.xdja.upgrade.task.SocketService;
import com.xdja.upgrade.task.UpdateModuleTask;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;

@Deprecated
public class ClientVersionTask
extends UpdateModuleTask<String, Integer, Integer> {
    public static final String TAG = ClientVersionTask.class.getName();
    private boolean isShowLoading;
    private ProgressDialogWrapper progressDialogWrapper;

    public ClientVersionTask(Context context) throws UpdateModuleException {
        super(context);
    }

    @Override
    public void template() throws ContextNullException {
        if (this.context == null) {
            throw new ContextNullException();
        }
        this.progressDialogWrapper = new ProgressDialogWrapper(this.context).setIsShowLoading(this.isShowLoading);
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.progressDialogWrapper.showLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(String ... params) {
        try (SocketService socketService = null;){
            SocketService.SocketResult socketResult;
            ClientVersion clientVersion = StorageIO.readClientVersion(this.context);
            if (clientVersion == null) {
                UpdateToast.show(this.context, "null");
                Integer n = -101;
                return n;
            }
            String installedVersion = AppUtil.getCurrentVersion(this.context);
            boolean isNull = installedVersion == null;
            UpdateLog.d(TAG, "installVersion", String.valueOf(isNull));
            if (!clientVersion.getVer().getVersion().equals(installedVersion)) {
                // empty if block
            }
            if ((socketResult = (socketService = new ClientVersionSocket(clientVersion)).executeSocket()).getResultCode() == -100) {
                byte[] data = socketResult.getResultBytes();
                StorageIO.deleteUpdateTemp(this.context);
                if (StorageIO.isUpdateSExist(this.context)) {
                    StorageIO.writeUpdateTemp(this.context, data);
                } else {
                    StorageIO.writeUpdateS(this.context, data);
                }
            }
            Integer n = socketResult.getResultCode();
            return n;
        }
    }

    @Override
    protected void onPostExecute(Integer result) {
        super.onPostExecute(result);
        this.progressDialogWrapper.dismiss();
        if (result != -100) {
            String warning = UpdateConfigConst.ConfigWrapper.getErrorDescription(result);
            Toast.makeText((Context)this.context, (CharSequence)warning, (int)0).show();
        } else {
            try {
                RXDConfig rxdConfig = StorageIO.readRxdConfig(this.context);
                AlertDialogWrapper alertDialogWrapper = new AlertDialogWrapper(this.context, this.isShowLoading);
                alertDialogWrapper.showDialog(rxdConfig);
            }
            catch (UpdateModuleException e) {
                e.printStackTrace();
            }
        }
    }

    public void setIsShowLoading(boolean isShowLoading) {
        this.isShowLoading = isShowLoading;
    }
}

