/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import android.content.Context;
import android.util.Log;
import com.xdja.upgrade.NetWorkUtil;
import com.xdja.upgrade.R;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.ClientVersion;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.exception.UpdateModuleException;
import com.xdja.upgrade.storage.ClientVersionStorage;
import com.xdja.upgrade.storage.RXDStorage;
import com.xdja.upgrade.storage.StorageIO;
import com.xdja.upgrade.task.CommonTask;
import com.xdja.upgrade.task.InstallTask;
import com.xdja.upgrade.task.RxdApkSocket;
import com.xdja.upgrade.task.SocketService;
import com.xdja.upgrade.ui.AlertDialogWrapper;
import com.xdja.upgrade.ui.ProgressDialogWrapper;
import com.xdja.upgrade.util.AlgUtil;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.TaskManager;
import com.xdja.upgrade.util.UpdateConfigConst;
import com.xdja.upgrade.util.UpdateToast;
import java.io.File;
import java.util.List;

public class DownloadApkTask
extends CommonTask<String, Integer, Integer> {
    public static final String TAG = DownloadApkTask.class.getName();
    RXDConfig config;
    RxdApkSocket socketService;
    ClientVersion clientVersion;
    List<com.xdja.upgrade.bean.update_s_bean.File> filesList;
    ProgressDialogWrapper dialog;

    @Override
    public String getTaskName() {
        return DownloadApkTask.class.getName();
    }

    public DownloadApkTask(Context context, RXDConfig config) {
        super(context);
        this.config = config;
        this.filesList = config.getUpdate().getFiles().getFiles();
        this.clientVersion = new ClientVersionStorage(context).read(context);
        this.socketService = new RxdApkSocket(context, this.clientVersion).setRXDConfig(config);
        this.dialog = new ProgressDialogWrapper(context, true);
    }

    public DownloadApkTask(Context context, RXDConfig config, ClientVersion clientVersion) {
        this(context, config);
        this.clientVersion = clientVersion;
        this.socketService = new RxdApkSocket(context, clientVersion).setRXDConfig(config);
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        UpdateLog.d(TAG, "\u5f00\u59cb\u4e0b\u8f7d\u6d41\u7a0b \u663e\u793a\u6eda\u52a8\u6761");
        this.dialog.showDownloading();
    }

    protected Integer doInBackground(String ... params) {
        UpdateLog.d(TAG, "\u89e3\u6790update_s.xml\u7684\u6587\u4ef6\u96c6\u4e3a\u7a7a\u5224\u65ad");
        if (this.filesList != null) {
            int fileSum = this.filesList.size();
            UpdateLog.d(TAG, "\u68c0\u6d4b\u672c\u5730\u5df2\u4e0b\u8f7d\u6570\u636e\u5927\u5c0f");
            for (int i = 0; i < fileSum; ++i) {
                com.xdja.upgrade.bean.update_s_bean.File updateServerFile = this.filesList.get(i);
                long downloadedSize = updateServerFile.getDownloadSize();
                long serverFileSIze = updateServerFile.getFileSize();
                Log.d((String)TAG, (String)("\u5df2\u4e0b\u8f7d\u5927\u5c0f\uff1a" + downloadedSize + " \u670d\u52a1\u5668\u76ee\u6807\u6587\u4ef6\u5927\u5c0f\uff1a" + serverFileSIze));
                if (downloadedSize >= serverFileSIze) {
                    UpdateLog.d(TAG, "\u4e0d\u542f\u52a8\u4e0b\u8f7d\u6d41\u7a0b\uff0c\u542f\u52a8\u6821\u9a8c\u5df2\u4e0b\u8f7d\u5305");
                    int result = this.checkApk(updateServerFile);
                    if (result == 0) continue;
                    this.download(updateServerFile);
                    return result;
                }
                UpdateLog.d(TAG, "\u5df2\u6709\u4e0b\u8f7d\u8fdb\u7a0b\u5224\u65ad");
                if (this.isDownloading()) {
                    UpdateLog.d(TAG, "\u4e0b\u8f7d\u8fdb\u884c\u6b63\u5728\u8fdb\u884c\u4e2d, \u5224\u65ad\u7f51\u7edc\u73af\u5883\u662f\u5426\u662fwifi");
                    if (NetWorkUtil.isWifi(this.context)) {
                        UpdateLog.d(TAG, "\u7f51\u7edc\u73af\u5883\u662fwifi, \u5f3a\u5236\u5347\u7ea7\u5224\u65ad");
                        if (this.isForceUpdate()) {
                            UpdateLog.d(TAG, "\u5f53\u524d\u7248\u672c\u9700\u8981\u5f3a\u5236\u5347\u7ea7\uff0c\u4e0d\u63d0\u793a\u7528\u6237\uff0c\u7ee7\u7eed\u4e4b\u524d\u7684\u4e0b\u8f7d\u6d41\u7a0b");
                            continue;
                        }
                        UpdateLog.d(TAG, "\u5f53\u524d\u7248\u672c\u4e0d\u9700\u8981\u5f3a\u5236\u5347\u7ea7\uff0c\u63d0\u793a\u7528\u6237\u6b63\u5728\u4e0b\u8f7d\uff0c\u7ee7\u7eed\u4e4b\u524d\u7684\u4e0b\u8f7d\u6d41\u7a0b");
                        UpdateToast.show(this.context, R.string.downloading);
                        continue;
                    }
                    UpdateLog.d(TAG, "\u7f51\u7edc\u73af\u5883\u4e0d\u662fwifi\uff0c\u63d0\u793a\u7528\u6237\u6b63\u5728\u4e0b\u8f7d\uff0c\u7ee7\u7eed\u4e4b\u524d\u4e0b\u8f7d\u6d41\u7a0b");
                    UpdateToast.show(this.context, R.string.downloading);
                    continue;
                }
                UpdateLog.d(TAG, "\u6ca1\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u4e0b\u8f7d\u8fdb\u7a0b");
                this.download(updateServerFile);
            }
        } else {
            UpdateLog.d(TAG, "update_s.xml\u7684\u6587\u4ef6\u96c6\u4e3a\u7a7a");
            return -122;
        }
        return 0;
    }

    private int download(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        UpdateLog.d(TAG, "\u542f\u52a8socket\u8fde\u63a5");
        long downloadedSize = updateServerFile.getDownloadSize();
        File file = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
        if (file.exists()) {
            long localFileSize = file.length();
            UpdateLog.d(TAG, "\u672c\u5730\u6587\u4ef6\u5927\u5c0f\uff1a" + localFileSize + " \u5df2\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\uff1a" + downloadedSize);
            if (localFileSize != downloadedSize) {
                updateServerFile.setDownloadSize(file.length());
            }
        }
        this.socketService.setUpdateServerFile(updateServerFile);
        SocketService.SocketResult result = this.socketService.executeSocket();
        UpdateLog.d(TAG, "\u83b7\u53d6\u6570\u636e\u6b63\u5e38\u5224\u65ad", result.getResultCode() + " ", UpdateConfigConst.ConfigWrapper.getErrorDescription(result.getResultCode()));
        if (result.getResultCode() == 0) {
            UpdateLog.d(TAG, "\u4e0b\u8f7d\u8bf7\u6c42\u6210\u529f");
            try {
                return this.writeApkFile(updateServerFile);
            }
            catch (UpdateModuleException e) {
                return -1;
            }
        }
        UpdateLog.d(TAG, "\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u5220\u9664update_s.xml", "\u9519\u8bef\u7801\uff1a", result.getResultCode() + "");
        int errorCode = result.getResultCode();
        if (errorCode == -105 || errorCode == -106 || errorCode == -107) {
            StorageIO.rewriteUpdateS(this.context, this.config);
        }
        UpdateToast.show(this.context, SocketService.getResultMessage(result.getResultCode()));
        return -1;
    }

    private int checkApk(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        File file = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
        UpdateLog.d(TAG, "\u5b89\u88c5\u5305\u5b58\u5728\u5224\u65ad");
        if (file.exists()) {
            UpdateLog.d(TAG, "\u5b89\u88c5\u5305\u5b58\u5728 \u6821\u9a8c\u5305MD5");
            try {
                String md5 = AlgUtil.getMD5Hash(file);
                if (md5.equals(updateServerFile.getCheckCode())) {
                    UpdateLog.d(TAG, "MD5\u6821\u9a8c\u6210\u529f \u8fdb\u5165\u5b89\u88c5\u6d41\u7a0b");
                    return 0;
                }
                UpdateLog.d(TAG, "MD5\u6821\u9a8c\u5931\u8d25");
                file.delete();
                return -116;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -116;
            }
        }
        UpdateLog.d(TAG, "\u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
        return -117;
    }

    protected void onPostExecute(Integer resultCode) {
        super.onPostExecute((Object)resultCode);
        this.dialog.dismiss();
        if (resultCode == 0) {
            UpdateLog.d(TAG, "\u5b89\u88c5\u5bf9\u5e94apk");
            InstallTask task = new InstallTask(this.context, this.config);
            task.execute(new Void[0]);
        } else {
            String errorMsg = UpdateConfigConst.ConfigWrapper.getErrorDescription(resultCode);
            UpdateLog.d(TAG, "\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u7801" + resultCode + ":" + errorMsg);
            AlertDialogWrapper.downloadFailureDialog(this.context);
        }
        StorageIO.deleteUpdateS(this.context);
    }

    private boolean isDownloading() {
        return TaskManager.getInstance().isTaskRunning(this);
    }

    private boolean isForceUpdate() {
        return this.config.isForceUpdate();
    }

    private int writeApkFile(com.xdja.upgrade.bean.update_s_bean.File updateServerFile) {
        UpdateLog.d(TAG, "Socket\u6570\u636e\u5199\u5165\u672c\u5730\u5f00\u59cb");
        File downloadingFile = new File(AppUtil.getAppAbsolutePath(this.context) + "/" + updateServerFile.getFileName());
        int fileSize = (int)updateServerFile.getFileSize();
        int downloadedSize = (int)updateServerFile.getDownloadSize();
        UpdateLog.d(TAG, "\u5df2\u4e0b\u8f7d\u5927\u5c0f\uff1a" + downloadedSize + " \u670d\u52a1\u5668\u76ee\u6807\u6587\u4ef6\u5927\u5c0f\uff1a" + fileSize);
        String fileName = updateServerFile.getFileName();
        boolean modifyPermission = false;
        while (downloadedSize < fileSize) {
            int bucket = fileSize - downloadedSize;
            byte[] data = new byte[bucket];
            try {
                int currentLen = this.socketService.read(data, 0, bucket);
                if (currentLen == -1) {
                    UpdateLog.d(TAG, "Socket\u6570\u636e\u8bfb\u53d6\u5f02\u5e38" + this.config.toString());
                    RXDStorage.writeDefaultXml(this.context, this.config);
                    StorageIO.rewriteUpdateS(this.context, this.config);
                    return -114;
                }
                try {
                    this.publishProgress(new Integer[]{(int)((float)(downloadedSize += currentLen) / (float)fileSize * 100.0f), downloadedSize});
                    StorageIO.writeFileAppend(AppUtil.getAppAbsolutePath(this.context) + "/" + fileName, data, currentLen);
                    if (!modifyPermission) {
                        Runtime.getRuntime().exec("chmod 644 " + AppUtil.getAppAbsolutePath(this.context) + "/" + fileName);
                        modifyPermission = true;
                    }
                    if (downloadedSize >= fileSize) {
                        updateServerFile.setState("2");
                        UpdateLog.d(TAG, "\u5199\u5165\u5927\u5c0f\u5927\u4e8e\u7b49\u4e8e\u6587\u4ef6\u603b\u5927\u5c0f\u5224\u65ad\uff1a\u662f");
                        StorageIO.rewriteUpdateS(this.context, this.config);
                        String md5Hash = AlgUtil.getMD5Hash(AppUtil.getAppAbsolutePath(this.context) + "/" + fileName);
                        if (md5Hash.equals(updateServerFile.getCheckCode())) continue;
                        UpdateLog.d(TAG, "\u6821\u9a8c\u5305md5\u5f02\u5e38, \u5220\u9664\u6587\u4ef6");
                        downloadingFile.delete();
                        return -116;
                    }
                    updateServerFile.setState("1");
                    StorageIO.rewriteUpdateS(this.context, this.config);
                }
                catch (Exception e) {
                    UpdateLog.d(TAG, "\u6570\u636e\u5199\u5165\u5f02\u5e38\uff0c\u5220\u9664\u5df2\u4e0b\u8f7d\u6587\u4ef6" + this.config.toString());
                    downloadingFile.delete();
                    updateServerFile.setState("0");
                    updateServerFile.setDownloadSize(0L);
                    StorageIO.rewriteUpdateS(this.context, this.config);
                    return -115;
                }
            }
            catch (Exception e) {
                return -114;
            }
        }
        UpdateLog.d(TAG, "apk\u5199\u5165\u6210\u529f");
        return 0;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        this.dialog.setProgress(values[0]);
    }
}

