/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.upgrade.task;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.widget.Toast;
import com.xdja.upgrade.UpdateLog;
import com.xdja.upgrade.bean.RXDConfig;
import com.xdja.upgrade.task.CommonTask;
import com.xdja.upgrade.util.AppUtil;
import com.xdja.upgrade.util.SPUtil;
import com.xdja.upgrade.util.TaskManager;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.util.List;

public class InstallTask
extends CommonTask<Void, Void, Void> {
    public static final String TAG = InstallTask.class.getName();
    public static final String FORCE_UPDATE_RESULT = "force_update_result";
    RXDConfig config;
    String filename;

    public InstallTask(Context context, RXDConfig config) {
        super(context);
        this.config = config;
        this.initFileName();
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        UpdateLog.d(TAG, "apk\u5b89\u88c5\u5f00\u59cb");
    }

    @Override
    public String getTaskName() {
        return null;
    }

    protected Void doInBackground(Void ... params) {
        UpdateLog.d(TAG, "\u68c0\u6d4b\u5f53\u524d\u662f\u5426\u5df2\u6709\u5b89\u88c5\u6d41\u7a0b");
        if (!this.isInstalling()) {
            TaskManager.getInstance().putTask(this);
            UpdateLog.d(TAG, "\u68c0\u6d4b\u662f\u5426\u662f\u5f3a\u5236\u5347\u7ea7");
            if (this.forceUpdate()) {
                if (!this.isSystemSigned()) {
                    UpdateLog.d(TAG, "\u9700\u8981\u5f3a\u5236\u5347\u7ea7\uff0c\u6ca1\u6709\u7cfb\u7edf\u7b7e\u540d\uff0c\u63d0\u793a\u7528\u6237\u5b89\u88c5");
                } else {
                    UpdateLog.d(TAG, "\u9700\u8981\u5f3a\u5236\u5347\u7ea7\uff0c\u6709\u7cfb\u7edf\u7b7e\u540d\uff0c\u9759\u9ed8\u5b89\u88c5");
                    this.installSilienclly(AppUtil.getAppAbsolutePath(this.context) + "/" + this.filename);
                }
            } else {
                UpdateLog.d(TAG, "\u4e0d\u9700\u8981\u5f3a\u5236\u5347\u7ea7\uff0c\u63d0\u793a\u7528\u6237\u5b89\u88c5");
                this.install();
            }
        } else {
            UpdateLog.d(TAG, "\u6709APK\u6b63\u5728\u8fdb\u884c\u5b89\u88c5,\u7ec8\u6b62\u5f53\u524d\u52a8\u4f5c\uff0c\u7b49\u5f85\u4e4b\u524d\u7684\u5b89\u88c5\u6d41\u7a0b\u5b8c\u6210");
        }
        return null;
    }

    public boolean forceUpdate() {
        return this.config.isForceUpdate();
    }

    public boolean isInstalling() {
        return TaskManager.getInstance().isTaskRunning(this);
    }

    public boolean isSystemSigned() {
        return false;
    }

    private void install() {
        UpdateLog.d(TAG, "\u663e\u793a\u5b89\u88c5");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setDataAndType(Uri.fromFile((File)new File(AppUtil.getAppAbsolutePath(this.context) + "/" + this.filename)), "application/vnd.android.package-archive");
        this.context.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installSilienclly(String apkPath) {
        String cmd = "pm install -r " + apkPath;
        Process process = null;
        FilterOutputStream os = null;
        BufferedReader successResult = null;
        BufferedReader errorResult = null;
        StringBuilder successMsg = new StringBuilder("success");
        StringBuilder errorMsg = new StringBuilder("error");
        try {
            String s;
            process = Runtime.getRuntime().exec("su");
            process = Runtime.getRuntime().exec(cmd);
            os = new DataOutputStream(process.getOutputStream());
            os.write(cmd.getBytes());
            ((DataOutputStream)os).writeBytes("\n");
            ((DataOutputStream)os).writeBytes("exit\n");
            ((DataOutputStream)os).flush();
            process.waitFor();
            successResult = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorResult = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((s = successResult.readLine()) != null) {
                successMsg.append(s);
            }
            while ((s = errorResult.readLine()) != null) {
                errorMsg.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (process != null) {
                    process.destroy();
                }
                if (successResult != null) {
                    successResult.close();
                }
                if (errorResult != null) {
                    errorResult.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        UpdateLog.d(TAG, "\u9759\u9ed8\u5b89\u88c5\u7ed3\u679c" + successMsg.toString() + "\n" + errorMsg.toString());
    }

    protected void onPostExecute(Void aVoid) {
        super.onPostExecute((Object)aVoid);
        TaskManager.getInstance().removeTask(this);
        Toast.makeText((Context)this.context, (CharSequence)"\u5b89\u88c5\u5b8c\u6210", (int)0).show();
    }

    private void initFileName() {
        List<com.xdja.upgrade.bean.update_s_bean.File> files = this.config.getUpdate().getFiles().getFiles();
        com.xdja.upgrade.bean.update_s_bean.File file = files.get(files.size() - 1);
        this.filename = file.getFileName();
    }

    public boolean checkForceInstallResult() {
        return (Boolean)SPUtil.get(this.context, FORCE_UPDATE_RESULT, false);
    }

    public void setForceUpdateSuccess() {
        SPUtil.put(this.context, FORCE_UPDATE_RESULT, true);
    }

    public void setForceUpdateFailed() {
        SPUtil.put(this.context, FORCE_UPDATE_RESULT, false);
    }
}

